/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.aggregation;

import java.util.Collection;
import java.util.function.Function;

public enum StandardAggregationFunctions implements Function<Collection<Double>, Double>
{
    AVERAGE{

        @Override
        public Double apply(Collection<Double> input) {
            if (input.isEmpty()) {
                return Double.NaN;
            }
            int count = 0;
            Double sum = 0.0;
            for (Double item : input) {
                if (Double.isNaN(item)) continue;
                sum = sum + item;
                ++count;
            }
            return sum / (double)count;
        }
    }
    ,
    MAX{

        @Override
        public Double apply(Collection<Double> input) {
            if (input.isEmpty()) {
                return Double.NaN;
            }
            Double max = Double.MIN_VALUE;
            for (Double item : input) {
                if (Double.isNaN(item)) continue;
                double diff = item - max;
                max = diff > 0.0 ? item : max;
            }
            return max;
        }
    }
    ,
    MIN{

        @Override
        public Double apply(Collection<Double> input) {
            if (input.isEmpty()) {
                return Double.NaN;
            }
            Double min = Double.MAX_VALUE;
            for (Double item : input) {
                if (Double.isNaN(item)) continue;
                double diff = item - min;
                min = diff < 0.0 ? item : min;
            }
            return min;
        }
    };

}

