/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.aggregation;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.netmgt.timeseries.integration.NewtsConverterUtils;
import org.opennms.newts.aggregate.ResultProcessor;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.ResultDescriptor;

public class NewtsLikeSampleAggregator {
    private final Resource resource;
    private final Timestamp start;
    private final Timestamp end;
    private final ResultDescriptor resultDescriptor;
    private final Duration resolution;
    private final Metric metric;

    private NewtsLikeSampleAggregator(Resource resource, Timestamp start, Timestamp end, ResultDescriptor descriptor, Duration resolution, Metric metric) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource argument");
        this.start = (Timestamp)Preconditions.checkNotNull((Object)start, (Object)"start argument");
        this.end = (Timestamp)Preconditions.checkNotNull((Object)end, (Object)"end argument");
        this.resultDescriptor = (ResultDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"result descriptor argument");
        this.resolution = (Duration)Preconditions.checkNotNull((Object)resolution, (Object)"resolution argument");
        this.metric = (Metric)Preconditions.checkNotNull((Object)metric, (Object)"metric argument");
    }

    public static NewtsLikeSampleAggregatorBuilder builder() {
        return new NewtsLikeSampleAggregatorBuilder();
    }

    public List<Sample> process(Iterator<Results.Row<org.opennms.newts.api.Sample>> samples) {
        Preconditions.checkNotNull(samples, (Object)"samples argument");
        Results measurements = new ResultProcessor(this.resource, this.start, this.end, this.resultDescriptor, this.resolution).process(samples);
        ArrayList<Sample> aggregatedSamples = new ArrayList<Sample>();
        for (Results.Row row : measurements) {
            aggregatedSamples.add(NewtsConverterUtils.toTimeseriesSample((Results.Row<Measurement>)row, this.metric));
        }
        return aggregatedSamples;
    }

    public static class NewtsLikeSampleAggregatorBuilder {
        private Resource resource;
        private Timestamp start;
        private Timestamp end;
        private ResultDescriptor resultDescriptor;
        private Duration resolution;
        private Metric metric;

        NewtsLikeSampleAggregatorBuilder() {
        }

        public NewtsLikeSampleAggregatorBuilder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder start(Timestamp start) {
            this.start = start;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder end(Timestamp end) {
            this.end = end;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder resultDescriptor(ResultDescriptor resultDescriptor) {
            this.resultDescriptor = resultDescriptor;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder resolution(Duration resolution) {
            this.resolution = resolution;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public NewtsLikeSampleAggregator build() {
            return new NewtsLikeSampleAggregator(this.resource, this.start, this.end, this.resultDescriptor, this.resolution, this.metric);
        }

        public String toString() {
            return "NewtsLikeSampleAggregator.NewtsLikeSampleAggregatorBuilder(resource=" + this.resource + ", start=" + this.start + ", end=" + this.end + ", resultDescriptor=" + this.resultDescriptor + ", resolution=" + this.resolution + ", metric=" + this.metric + ")";
        }
    }
}

