/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesFetchRequest;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.QueryMetadata;
import org.opennms.netmgt.measurements.model.QueryNode;
import org.opennms.netmgt.measurements.model.QueryResource;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.timeseries.impl.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.integration.NewtsConverterUtils;
import org.opennms.netmgt.timeseries.integration.Utils;
import org.opennms.netmgt.timeseries.integration.aggregation.NewtsLikeSampleAggregator;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.SampleSelectCallback;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.api.query.StandardAggregationFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;

public class TimeseriesFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesFetchStrategy.class);
    public static final long MIN_STEP_MS = SystemProperties.getLong((String)"org.opennms.timeseries.query.minimum_step", (Long)300000L);
    public static final int INTERVAL_DIVIDER = SystemProperties.getInteger((String)"org.opennms.timeseries.query.interval_divider", (int)2);
    public static final long DEFAULT_HEARTBEAT_MS = SystemProperties.getLong((String)"org.opennms.timeseries.query.heartbeat", (Long)450000L);
    public static final int PARALLELISM = SystemProperties.getInteger((String)"org.opennms.timeseries.query.parallelism", (int)Runtime.getRuntime().availableProcessors());
    @Autowired
    private ResourceDao resourceDao;
    private final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("TimeseriesFetchStrateg-%d").build();
    private final ExecutorService threadPool = Executors.newCachedThreadPool(this.namedThreadFactory);
    private final Semaphore availableAggregationThreads = new Semaphore(PARALLELISM);
    @Autowired
    private TimeseriesStorageManager storageManager;
    private SampleSelectCallback limitConcurrentAggregationsCallback = new SampleSelectCallback(){

        public void beforeProcess() {
            try {
                TimeseriesFetchStrategy.this.availableAggregationThreads.acquire();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void afterProcess() {
            TimeseriesFetchStrategy.this.availableAggregationThreads.release();
        }
    };

    /*
     * WARNING - void declaration
     */
    public FetchResults fetch(long start, long end, long step, int maxrows, Long interval, Long heartbeat, List<Source> sources, boolean relaxed) {
        void var22_29;
        LateAggregationParams lag = TimeseriesFetchStrategy.getLagParams(step, interval, heartbeat);
        Optional startTs = Optional.of((Object)Timestamp.fromEpochMillis((long)start));
        Optional endTs = Optional.of((Object)Timestamp.fromEpochMillis((long)end));
        HashMap constants = Maps.newHashMap();
        ArrayList<QueryResource> resources = new ArrayList<QueryResource>();
        Map<ResourceId, List<Source>> sourcesByResourceId = sources.stream().collect(Collectors.groupingBy(source -> ResourceId.fromString((String)source.getResourceId())));
        HashMap resourceFuturesById = Maps.newHashMapWithExpectedSize((int)sourcesByResourceId.size());
        for (ResourceId resourceId : sourcesByResourceId.keySet()) {
            resourceFuturesById.put(resourceId, this.threadPool.submit(this.getResourceByIdCallable(resourceId)));
        }
        HashMap sourcesByResource = Maps.newHashMapWithExpectedSize((int)sourcesByResourceId.size());
        for (Map.Entry entry : resourceFuturesById.entrySet()) {
            try {
                OnmsResource onmsResource = (OnmsResource)((Future)entry.getValue()).get();
                if (onmsResource == null) {
                    if (relaxed) continue;
                    LOG.error("No resource with id: {}", entry.getKey());
                    return null;
                }
                sourcesByResource.put(onmsResource, sourcesByResourceId.get(entry.getKey()));
            }
            catch (InterruptedException | ExecutionException exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : sourcesByResource.entrySet()) {
            OnmsResource onmsResource = (OnmsResource)entry.getKey();
            for (Source source2 : (List)entry.getValue()) {
                List listOfSources;
                org.opennms.netmgt.measurements.utils.Utils.convertStringAttributesToConstants((String)source2.getLabel(), (Map)onmsResource.getStringPropertyAttributes(), (Map)constants);
                resources.add(this.getResourceInfo(onmsResource, source2));
                RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)onmsResource.getRrdGraphAttributes().get(source2.getAttribute());
                if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source2.getFallbackAttribute())) {
                    LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source2.getAttribute(), (Object)source2.getFallbackAttribute());
                    source2.setAttribute(source2.getFallbackAttribute());
                    source2.setFallbackAttribute(null);
                    rrdGraphAttribute = (RrdGraphAttribute)onmsResource.getRrdGraphAttributes().get(source2.getAttribute());
                }
                if (rrdGraphAttribute == null) {
                    if (relaxed) continue;
                    LOG.error("No attribute with name: {}", (Object)source2.getAttribute());
                    return null;
                }
                String newtsResourceId = rrdGraphAttribute.getRrdRelativePath();
                if (newtsResourceId.startsWith(File.separator)) {
                    newtsResourceId = newtsResourceId.substring(File.separator.length(), newtsResourceId.length());
                }
                if ((listOfSources = (List)hashMap.get(newtsResourceId)) == null) {
                    listOfSources = Lists.newLinkedList();
                    hashMap.put(newtsResourceId, listOfSources);
                }
                listOfSources.add(source2);
            }
        }
        HashMap hashMap2 = Maps.newHashMapWithExpectedSize((int)hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), this.threadPool.submit(this.getMeasurementsForResourceCallable((String)entry.getKey(), (List)entry.getValue(), (Optional<Timestamp>)startTs, (Optional<Timestamp>)endTs, lag)));
        }
        Object var22_28 = null;
        HashMap hashMap3 = Maps.newHashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            int k;
            Collection rows;
            try {
                rows = (Collection)((Future)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int N = rows.size();
            if (var22_29 == null) {
                long[] lArray = new long[N];
                k = 0;
                for (Results.Row row : rows) {
                    lArray[k] = row.getTimestamp().asMillis();
                    ++k;
                }
            }
            k = 0;
            for (Results.Row row : rows) {
                for (Measurement measurement : row.getElements()) {
                    double[] column = (double[])hashMap3.get(measurement.getName());
                    if (column == null) {
                        column = new double[N];
                        hashMap3.put(measurement.getName(), column);
                    }
                    column[k] = measurement.getValue();
                }
                ++k;
            }
        }
        FetchResults fetchResults = new FetchResults((long[])var22_29, (Map)hashMap3, lag.getStep(), (Map)constants, new QueryMetadata(resources));
        if (relaxed) {
            org.opennms.netmgt.measurements.utils.Utils.fillMissingValues((FetchResults)fetchResults, sources);
        }
        LOG.trace("Fetch results: {}", (Object)fetchResults);
        return fetchResults;
    }

    private Callable<Collection<Results.Row<Measurement>>> getMeasurementsForResourceCallable(final String resourceId, final List<Source> listOfSources, final Optional<Timestamp> start, final Optional<Timestamp> end, final LateAggregationParams lag) {
        return new Callable<Collection<Results.Row<Measurement>>>(){

            @Override
            public Collection<Results.Row<Measurement>> call() throws Exception {
                ArrayList<List<Sample>> allSamples = new ArrayList<List<Sample>>();
                for (Source source : listOfSources) {
                    String metricName = source.getDataSource() != null ? source.getDataSource() : source.getAttribute();
                    Aggregation aggregation = TimeseriesFetchStrategy.toAggregation(source.getAggregation());
                    boolean shouldAggregateNatively = TimeseriesFetchStrategy.this.storageManager.get().supportsAggregation(aggregation);
                    ImmutableMetric metric = ImmutableMetric.builder().intrinsicTag("resourceId", resourceId).intrinsicTag("name", metricName).build();
                    Instant startInstant = Instant.ofEpochMilli(((Timestamp)start.or((Object)Timestamp.fromEpochMillis((long)0L))).asMillis());
                    Instant endInstant = Instant.ofEpochMilli(((Timestamp)end.or((Object)Timestamp.now())).asMillis());
                    Aggregation aggregationToUse = shouldAggregateNatively ? aggregation : Aggregation.NONE;
                    ImmutableTimeSeriesFetchRequest request = ImmutableTimeSeriesFetchRequest.builder().metric((Metric)metric).start(startInstant).end(endInstant).step(java.time.Duration.ofMillis(lag.getStep())).aggregation(aggregationToUse).build();
                    LOG.debug("Querying TimeseriesStorage for resource id {} with request: {}", (Object)resourceId, (Object)request);
                    List<Sample> samples = TimeseriesFetchStrategy.this.storageManager.get().getTimeseries((TimeSeriesFetchRequest)request);
                    if (!shouldAggregateNatively) {
                        List<Source> currentSources = Collections.singletonList(source);
                        ResultDescriptor resultDescriptor = TimeseriesFetchStrategy.this.createResultDescriptor(currentSources, lag);
                        samples = NewtsLikeSampleAggregator.builder().resource(new Resource(resourceId)).start((Timestamp)start.or((Object)Timestamp.fromEpochMillis((long)0L))).end((Timestamp)end.or((Object)Timestamp.now())).resolution(Duration.millis((long)lag.getStep())).resultDescriptor(resultDescriptor).metric((Metric)metric).build().process(NewtsConverterUtils.samplesToNewtsRowIterator(samples, currentSources));
                    }
                    allSamples.add(samples);
                }
                ArrayList<Results.Row<Measurement>> rows = new ArrayList<Results.Row<Measurement>>();
                for (int rowIndex = 0; rowIndex < ((List)allSamples.get(0)).size(); ++rowIndex) {
                    Sample sampleOfFirstList = (Sample)((List)allSamples.get(0)).get(rowIndex);
                    Timestamp timestamp = Timestamp.fromEpochMillis((long)sampleOfFirstList.getTime().toEpochMilli());
                    Optional resourceAttributes = sampleOfFirstList.getMetric().getMetaTags().isEmpty() ? Optional.absent() : Optional.of(Utils.asMap(sampleOfFirstList.getMetric().getMetaTags()));
                    Resource resource = new Resource(sampleOfFirstList.getMetric().getFirstTagByKey("resourceId").getValue(), resourceAttributes);
                    Results.Row row = new Results.Row(timestamp, resource);
                    for (int columnIndex = 0; columnIndex < allSamples.size(); ++columnIndex) {
                        List list = (List)allSamples.get(columnIndex);
                        Sample sampleOfCurrentList = (Sample)list.get(rowIndex);
                        String name = ((Source)listOfSources.get(columnIndex)).getLabel();
                        row.addElement((Element)new Measurement(timestamp, resource, name, sampleOfCurrentList.getValue().doubleValue(), new HashMap()));
                    }
                    rows.add((Results.Row<Measurement>)row);
                }
                LOG.debug("Found {} rows.", (Object)rows.size());
                return rows;
            }
        };
    }

    private ResultDescriptor createResultDescriptor(List<Source> listOfSources, LateAggregationParams lag) {
        ResultDescriptor resultDescriptor = new ResultDescriptor(lag.getInterval());
        for (Source source : listOfSources) {
            String metricName = source.getDataSource() != null ? source.getDataSource() : source.getAttribute();
            String name = source.getLabel();
            AggregationFunction fn = TimeseriesFetchStrategy.toAggregationFunction(source.getAggregation());
            resultDescriptor.datasource(name, metricName, lag.getHeartbeat(), fn);
            resultDescriptor.export(new String[]{name});
        }
        return resultDescriptor;
    }

    private static Aggregation toAggregation(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return Aggregation.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return Aggregation.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return Aggregation.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    private static AggregationFunction toAggregationFunction(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    private Callable<OnmsResource> getResourceByIdCallable(final ResourceId resourceId) {
        return new Callable<OnmsResource>(){

            @Override
            public OnmsResource call() throws IllegalArgumentException {
                OnmsResource resource = TimeseriesFetchStrategy.this.resourceDao.getResourceById(resourceId);
                if (resource != null) {
                    resource.getAttributes();
                }
                return resource;
            }
        };
    }

    @VisibleForTesting
    protected static LateAggregationParams getLagParams(long step, Long interval, Long heartbeat) {
        long effectiveHeartbeat;
        long effectiveStep = Math.max(MIN_STEP_MS, step);
        if (effectiveStep != step) {
            LOG.warn("Requested step size {} is too small. Using {}.", (Object)step, (Object)effectiveStep);
        }
        long effectiveInterval = 0L;
        if (interval != null && interval < effectiveStep && effectiveStep % interval == 0L) {
            effectiveInterval = interval;
        } else {
            if (effectiveStep % (long)INTERVAL_DIVIDER != 0L) {
                effectiveStep += effectiveStep % (long)INTERVAL_DIVIDER;
            }
            effectiveInterval = effectiveStep / (long)INTERVAL_DIVIDER;
        }
        long l = effectiveHeartbeat = heartbeat != null ? heartbeat : DEFAULT_HEARTBEAT_MS;
        if (effectiveInterval < effectiveHeartbeat) {
            if (effectiveHeartbeat % effectiveInterval != 0L) {
                effectiveHeartbeat += effectiveInterval - effectiveHeartbeat % effectiveInterval;
            }
        } else {
            effectiveHeartbeat = effectiveInterval + 1L;
            effectiveHeartbeat += effectiveHeartbeat % effectiveInterval;
        }
        return new LateAggregationParams(effectiveStep, effectiveInterval, effectiveHeartbeat);
    }

    @VisibleForTesting
    protected void setResourceDao(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    @VisibleForTesting
    protected void setTimeseriesStorageManager(TimeseriesStorageManager timeseriesStorage) {
        this.storageManager = timeseriesStorage;
    }

    private OnmsNode getNode(OnmsResource resource, Source source) {
        OnmsNode node = null;
        try {
            node = ResourceTypeUtils.getNodeFromResourceRoot((OnmsResource)resource);
        }
        catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
            // empty catch block
        }
        if (node == null) {
            OnmsResource otherResource = this.resourceDao.getResourceById(ResourceId.fromString((String)source.getResourceId()).getParent());
            node = ResourceTypeUtils.getNodeFromResource((OnmsResource)otherResource);
        }
        return node;
    }

    private QueryResource getResourceInfo(OnmsResource resource, Source source) {
        if (resource == null) {
            return null;
        }
        OnmsNode node = this.getNode(resource, source);
        return new QueryResource(resource.getId().toString(), resource.getParent() == null ? null : resource.getParent().getId().toString(), resource.getLabel(), resource.getName(), node == null ? null : new QueryNode(node.getId(), node.getForeignSource(), node.getForeignId(), node.getLabel()));
    }

    @VisibleForTesting
    protected static class LateAggregationParams {
        final long step;
        final long interval;
        final long heartbeat;

        public LateAggregationParams(long step, long interval, long heartbeat) {
            this.step = step;
            this.interval = interval;
            this.heartbeat = heartbeat;
        }

        public long getStep() {
            return this.step;
        }

        public long getInterval() {
            return this.interval;
        }

        public long getHeartbeat() {
            return this.heartbeat;
        }
    }
}

