/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration;

import com.google.common.base.Optional;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.timeseries.integration.Utils;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Counter;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Gauge;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

public class NewtsConverterUtils {
    public static Iterator<Results.Row<org.opennms.newts.api.Sample>> samplesToNewtsRowIterator(List<Sample> allSamples, List<Source> listOfSources) {
        return allSamples.stream().map(NewtsConverterUtils::sampleToRow).collect(Collectors.toList()).iterator();
    }

    private static Results.Row<org.opennms.newts.api.Sample> sampleToRow(Sample sample) {
        Optional resourceAttributes = sample.getMetric().getMetaTags().isEmpty() ? Optional.absent() : Optional.of(Utils.asMap(sample.getMetric().getMetaTags()));
        Timestamp timestamp = Timestamp.fromEpochMillis((long)sample.getTime().toEpochMilli());
        Context context = new Context("not relevant");
        Resource resource = new Resource(sample.getMetric().getFirstTagByKey("resourceId").getValue(), resourceAttributes);
        String name = sample.getMetric().getFirstTagByKey("name").getValue();
        MetricType type = NewtsConverterUtils.toNewts(Metric.Mtype.valueOf((String)sample.getMetric().getFirstTagByKey("mtype").getValue()));
        ValueType<?> value = NewtsConverterUtils.toNewtsValue(sample);
        HashMap attributes = new HashMap();
        org.opennms.newts.api.Sample newtsSample = new org.opennms.newts.api.Sample(timestamp, context, resource, name, type, value, attributes);
        Results.Row row = new Results.Row(timestamp, resource);
        row.addElement((Element)newtsSample);
        return row;
    }

    private static MetricType toNewts(Metric.Mtype type) {
        if (Metric.Mtype.count == type) {
            return MetricType.COUNTER;
        }
        if (Metric.Mtype.gauge == type) {
            return MetricType.GAUGE;
        }
        throw new IllegalArgumentException(String.format("I don't know how to map %s to MetricType", type));
    }

    private static ValueType<?> toNewtsValue(Sample sample) {
        Metric.Mtype mtype = Metric.Mtype.valueOf((String)sample.getMetric().getFirstTagByKey("mtype").getValue());
        if (Metric.Mtype.count == mtype) {
            return new Counter(sample.getValue().longValue());
        }
        if (Metric.Mtype.gauge == mtype) {
            return new Gauge(sample.getValue().doubleValue());
        }
        throw new IllegalArgumentException(String.format("I don't know how to map %s to ValueType", mtype));
    }

    public static Sample toTimeseriesSample(Results.Row<Measurement> row, Metric metric) {
        int sizeOfRow = row.getElements().size();
        if (row.getElements().size() != 1) {
            throw new IllegalArgumentException(String.format("expected exactly one column in row but was %s", sizeOfRow));
        }
        Measurement measurement = (Measurement)row.getElements().iterator().next();
        return ImmutableSample.builder().metric(metric).time(NewtsConverterUtils.toInstant(measurement.getTimestamp())).value(measurement.getValue()).build();
    }

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochMilli(timestamp.asMillis());
    }
}

