/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.evaluate;

import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.evaluate.AbstractEvaluatePersister;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluateStats;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluatorPersistOperationBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateGroupPersister
extends AbstractEvaluatePersister {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluateGroupPersister.class);

    public EvaluateGroupPersister(EvaluateStats stats, ServiceParameters params, RrdRepository repository) {
        super(stats, params, repository);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            String resourceId = this.getResourceId(group.getResource());
            String groupId = resourceId + '/' + group.getName();
            LOG.debug("visitGroup: {} = {}", (Object)groupId, (Object)group.getAttributes().size());
            this.stats.checkNode(group.getResource().getParent().getName());
            this.stats.checkGroup(groupId);
            this.stats.checkResource(resourceId);
            group.getAttributes().forEach(a -> {
                String attribId = resourceId + '/' + a.getName();
                if (a.getAttributeType().getType().isNumeric()) {
                    LOG.debug("visitGroup: attribute {}", (Object)attribId);
                    this.stats.checkAttribute(attribId, true);
                    this.stats.markNumericSamplesMeter();
                } else {
                    this.stats.checkAttribute(attribId, false);
                }
            });
            this.setBuilder(new EvaluatorPersistOperationBuilder());
        }
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

