/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.evaluate;

import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.evaluate.AbstractEvaluatePersister;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluateStats;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluatorPersistOperationBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateSinglePersister
extends AbstractEvaluatePersister {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluateSinglePersister.class);

    public EvaluateSinglePersister(EvaluateStats stats, ServiceParameters params, RrdRepository repository) {
        super(stats, params, repository);
    }

    public void visitAttribute(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute);
        if (this.shouldPersist()) {
            String resourceId = this.getResourceId(attribute.getResource());
            String attribId = resourceId + '/' + attribute.getName();
            LOG.debug("visitAttribute: {}", (Object)attribId);
            this.stats.checkNode(attribute.getResource().getParent().getName());
            this.stats.checkResource(resourceId);
            if (attribute.getAttributeType().getType().isNumeric()) {
                this.stats.checkAttribute(attribId, true);
                this.stats.markNumericSamplesMeter();
            } else {
                this.stats.checkAttribute(attribId, false);
            }
            this.setBuilder(new EvaluatorPersistOperationBuilder());
        }
    }

    public void completeAttribute(CollectionAttribute attribute) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

