/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.evaluate;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class EvaluateStats {
    private static final String LOGGING_PREFFIX = "EvaluationMetrics";
    private static final String LOGGING_SUFFIX = "-Cache";
    private static final Logger LOG = LoggerFactory.getLogger((String)"EvaluationMetrics");
    private final ConcurrentMap<String, Boolean> nodeMap = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, Boolean> interfaceMap = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, Boolean> resourceMap = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, Boolean> numericAttributeMap = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, Boolean> stringAttributeMap = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, Boolean> groupMap = new ConcurrentHashMap<String, Boolean>();
    private final Meter numericSamplesMeter;

    public EvaluateStats(MetricRegistry registry, Integer dumpStatsFreq, Integer dumpCacheFreq) {
        Assert.notNull((Object)registry, (String)"MetricRegistry is required");
        Assert.notNull((Object)dumpStatsFreq, (String)"Dump statistics frequency is required");
        Assert.isTrue((dumpStatsFreq > 0 ? 1 : 0) != 0, (String)"Dump statistics frequency must be positive");
        Assert.notNull((Object)dumpCacheFreq, (String)"Dump cache frequency is required");
        Assert.isTrue((dumpCacheFreq > 0 ? 1 : 0) != 0, (String)"Dump cache frequency must be positive");
        Gauge nodes = () -> this.nodeMap.keySet().size();
        registry.register(MetricRegistry.name((String)"evaluate", (String[])new String[]{"nodes"}), (Metric)nodes);
        Gauge interfaces = () -> this.interfaceMap.keySet().size();
        registry.register(MetricRegistry.name((String)"evaluate", (String[])new String[]{"interfaces"}), (Metric)interfaces);
        Gauge resources = () -> this.resourceMap.keySet().size();
        registry.register(MetricRegistry.name((String)"evaluate", (String[])new String[]{"resources"}), (Metric)resources);
        Gauge numericAttributes = () -> this.numericAttributeMap.keySet().size();
        registry.register(MetricRegistry.name((String)"evaluate", (String[])new String[]{"numeric-attributes"}), (Metric)numericAttributes);
        Gauge stringAttributes = () -> this.stringAttributeMap.keySet().size();
        registry.register(MetricRegistry.name((String)"evaluate", (String[])new String[]{"string-attributes"}), (Metric)stringAttributes);
        if (ResourceTypeUtils.isStoreByGroup()) {
            Gauge groups = () -> this.groupMap.keySet().size();
            registry.register(MetricRegistry.name((String)"evaluate", (String[])new String[]{"groups"}), (Metric)groups);
        }
        this.numericSamplesMeter = registry.meter(MetricRegistry.name((String)"evaluate", (String[])new String[]{"samples"}));
        Logging.withPrefix((String)LOGGING_PREFFIX, () -> {
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)registry).outputTo(LOG).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start((long)dumpStatsFreq.intValue(), TimeUnit.MINUTES);
        });
        Logging.withPrefix((String)"EvaluationMetrics-Cache", () -> {
            ScheduledExecutorService svc = Executors.newScheduledThreadPool(1);
            svc.scheduleAtFixedRate(() -> this.dumpCache(), 0L, dumpCacheFreq.intValue(), TimeUnit.MINUTES);
        });
    }

    public void checkNode(String nodeId) {
        if (nodeId.startsWith("fs") || nodeId.matches("\\d+")) {
            this.nodeMap.putIfAbsent(nodeId, true);
        } else {
            this.interfaceMap.putIfAbsent(nodeId, true);
        }
    }

    public void checkResource(String resourceId) {
        this.resourceMap.putIfAbsent(resourceId, true);
    }

    public void checkAttribute(String attributeId, boolean isNumeric) {
        if (isNumeric) {
            this.numericAttributeMap.putIfAbsent(attributeId, true);
        } else {
            this.stringAttributeMap.putIfAbsent(attributeId, true);
        }
    }

    public void checkGroup(String groupId) {
        this.groupMap.putIfAbsent(groupId, true);
    }

    public void markNumericSamplesMeter() {
        this.numericSamplesMeter.mark();
    }

    protected void dumpCache() {
        this.nodeMap.keySet().stream().sorted().forEach(s -> LOG.info("node: {}", s));
        this.interfaceMap.keySet().stream().sorted().forEach(s -> LOG.info("interface: {}", s));
        this.resourceMap.keySet().stream().sorted().forEach(s -> LOG.info("resource: {}", s));
        this.groupMap.keySet().stream().sorted().forEach(s -> LOG.info("group: {}", s));
        this.numericAttributeMap.keySet().stream().sorted().forEach(s -> LOG.info("numeric-attribute: {}", s));
        this.stringAttributeMap.keySet().stream().sorted().forEach(s -> LOG.info("string-attribute: {}", s));
    }
}

