/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ThreadReportPlugin
extends AbstractSystemReportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadReportPlugin.class);

    @Override
    public String getName() {
        return "Threads";
    }

    @Override
    public String getDescription() {
        return "Java thread dump (full output only)";
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        StringBuilder sb = new StringBuilder();
        try {
            ThreadInfo[] threads;
            for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                sb.append(info.toString());
            }
            map.put("ThreadDump.txt", this.getResource(sb.toString()));
        }
        catch (Exception e) {
            LOG.debug("Unable to get thread dump.", (Throwable)e);
        }
        return map;
    }
}

