/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.util.Map;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class TextSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(TextSystemReportFormatter.class);

    @Override
    public String getName() {
        return "text";
    }

    @Override
    public String getDescription() {
        return "Simple human-readable indented text";
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getExtension() {
        return "txt";
    }

    @Override
    public boolean canStdout() {
        return true;
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        if (!this.hasDisplayable(plugin)) {
            return;
        }
        LOG.debug("write({})", (Object)plugin.getName());
        try {
            String title = plugin.getName() + " (" + plugin.getDescription() + "):" + "\n";
            this.getOutputStream().write(title.getBytes());
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                Resource value = entry.getValue();
                boolean displayable = this.isDisplayable(value);
                String text = displayable ? "\t" + entry.getKey() + ": " + this.getResourceText(value) + "\n" : "\t" + entry.getKey() + ": " + (value == null ? "NULL" : value.getClass().getSimpleName() + " resource is not displayable.  Try using the 'zip' format.") + "\n";
                this.getOutputStream().write(text.getBytes());
            }
        }
        catch (Throwable e) {
            LOG.error("Error writing plugin data.", e);
        }
    }
}

