/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.opennms.systemreport.formatters.ZipSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(FtpSystemReportFormatter.class);
    private URL m_url;
    private ZipSystemReportFormatter m_zipFormatter;
    private File m_zipFile;

    @Override
    public String getName() {
        return "ftp";
    }

    @Override
    public String getDescription() {
        return "FTP to the URL specified in the output option (eg. ftp://username:password@ftp.example.com/incoming/my-file.zip) (full output)";
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public String getExtension() {
        return "zip";
    }

    @Override
    public boolean canStdout() {
        return false;
    }

    @Override
    public boolean needsOutputStream() {
        return false;
    }

    @Override
    public void begin() {
        super.begin();
        try {
            this.m_url = new URL(this.getOutput());
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to parse {} as an FTP URL", (Object)this.getOutput(), (Object)e);
            throw new IllegalArgumentException(String.format("Unable to parse \"%s\" as an FTP URL", this.getOutput()));
        }
        if (!this.m_url.getProtocol().equalsIgnoreCase("ftp")) {
            LOG.error("URL {} is not an FTP URL", (Object)this.m_url);
            throw new IllegalArgumentException(String.format("URL \"%s\" is not an FTP URL", this.getOutput()));
        }
        this.m_zipFormatter = new ZipSystemReportFormatter();
        try {
            this.m_zipFile = File.createTempFile("ftpSystemReportFormatter", null);
            LOG.debug("Temporary ZIP file for system report FTP transfer = {}", (Object)this.m_zipFile.getPath());
            this.m_outputStream = new FileOutputStream(this.m_zipFile);
            this.m_zipFormatter.setOutput(this.getOutput());
            this.m_zipFormatter.setOutputStream(this.m_outputStream);
            this.m_zipFormatter.begin();
        }
        catch (IOException e) {
            LOG.error("Unable to create temporary file for system report FTP transfer", (Throwable)e);
            throw new IllegalStateException("Unable to create temporary file for system report FTP transfer");
        }
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        if (this.m_url == null) {
            return;
        }
        this.m_zipFormatter.write(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void end() {
        FileInputStream fis;
        FTPClient ftp;
        block33: {
            block32: {
                this.m_zipFormatter.end();
                IOUtils.closeQuietly((OutputStream)this.m_outputStream);
                ftp = new FTPClient();
                fis = null;
                try {
                    if (this.m_url.getPort() == -1 || this.m_url.getPort() == 0 || this.m_url.getPort() == this.m_url.getDefaultPort()) {
                        ftp.connect(this.m_url.getHost());
                    } else {
                        ftp.connect(this.m_url.getHost(), this.m_url.getPort());
                    }
                    if (this.m_url.getUserInfo() != null && this.m_url.getUserInfo().length() > 0) {
                        String[] userInfo = this.m_url.getUserInfo().split(":", 2);
                        ftp.login(userInfo[0], userInfo[1]);
                    } else {
                        ftp.login("anonymous", "opennmsftp@");
                    }
                    int reply = ftp.getReplyCode();
                    if (!FTPReply.isPositiveCompletion((int)reply)) {
                        ftp.disconnect();
                        LOG.error("FTP server refused connection.");
                        return;
                    }
                    String path = this.m_url.getPath();
                    if (path.endsWith("/")) {
                        LOG.error("Your FTP URL must specify a filename.");
                        return;
                    }
                    File f = new File(path);
                    if (!ftp.changeWorkingDirectory(path = f.getParent())) {
                        LOG.info("unable to change working directory to {}", (Object)path);
                        return;
                    }
                    LOG.info("uploading {} to {}", (Object)f.getName(), (Object)path);
                    ftp.setFileType(2);
                    ftp.enterLocalPassiveMode();
                    fis = new FileInputStream(this.m_zipFile);
                    if (!ftp.storeFile(f.getName(), (InputStream)fis)) {
                        LOG.info("unable to store file");
                        IOUtils.closeQuietly((InputStream)fis);
                        break block32;
                    }
                    LOG.info("finished uploading");
                    IOUtils.closeQuietly((InputStream)fis);
                    break block33;
                }
                catch (Exception e) {
                    LOG.error("Unable to FTP file to {}", (Object)this.m_url, (Object)e);
                    return;
                }
            }
            if (!ftp.isConnected()) return;
            try {
                ftp.disconnect();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        if (!ftp.isConnected()) return;
        try {
            ftp.disconnect();
            return;
        }
        catch (IOException reply) {
            return;
        }
        finally {
            IOUtils.closeQuietly(fis);
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

