/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.opennms;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.CountedObject;
import org.opennms.netmgt.dao.api.EventCountDao;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class TopEventReportPlugin
extends AbstractSystemReportPlugin
implements InitializingBean {
    @Autowired
    public EventCountDao m_eventCountDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    public String getName() {
        return "TopEvent";
    }

    @Override
    public String getDescription() {
        return "Top 20 most reported events";
    }

    @Override
    public int getPriority() {
        return 4;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        if (this.m_eventCountDao != null) {
            Set objs = this.m_eventCountDao.getUeiCounts(Integer.valueOf(20));
            for (CountedObject obj : objs) {
                map.put((String)obj.getObject(), (Resource)new ByteArrayResource(obj.getCount().toString().getBytes()));
            }
        }
        return map;
    }
}

