/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.xml.sax.helpers.AttributesImpl;

public class XmlSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSystemReportFormatter.class);
    private TransformerHandler m_handler = null;

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public String getDescription() {
        return "Simple output in XML text format";
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getExtension() {
        return "xml";
    }

    @Override
    public boolean canStdout() {
        return true;
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        if (!this.hasDisplayable(plugin)) {
            return;
        }
        if (this.m_handler == null) {
            try {
                StreamResult streamResult = new StreamResult(this.getOutputStream());
                SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                this.m_handler = tf.newTransformerHandler();
                Transformer serializer = this.m_handler.getTransformer();
                serializer.setOutputProperty("cdata-section-elements", "entry");
                this.m_handler.setResult(streamResult);
            }
            catch (Exception e) {
                LOG.error("Unable to create XML stream writer.", (Throwable)e);
                this.m_handler = null;
            }
            try {
                this.m_handler.startDocument();
                this.m_handler.startElement("", "", "systemReportPlugins", null);
            }
            catch (Exception e) {
                LOG.warn("Unable to start document.", (Throwable)e);
                this.m_handler = null;
            }
        }
        if (this.m_handler == null) {
            LOG.warn("Unable to write, no handler defined!");
            return;
        }
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "CDATA", plugin.getName());
            atts.addAttribute("", "", "description", "CDATA", plugin.getDescription());
            this.m_handler.startElement("", "", "plugin", atts);
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                String value;
                boolean displayable = this.isDisplayable(entry.getValue());
                atts = new AttributesImpl();
                atts.addAttribute("", "", "key", "CDATA", entry.getKey());
                if (!displayable) {
                    atts.addAttribute("", "", "skipped", "CDATA", "true");
                }
                this.m_handler.startElement("", "", "entry", atts);
                if (displayable && (value = this.getResourceText(entry.getValue())) != null) {
                    this.m_handler.startCDATA();
                    this.m_handler.characters(value.toCharArray(), 0, value.length());
                    this.m_handler.endCDATA();
                }
                this.m_handler.endElement("", "", "entry");
            }
            this.m_handler.endElement("", "", "plugin");
        }
        catch (Exception e) {
            LOG.warn("An error occurred while attempting to write XML data.", (Throwable)e);
        }
    }

    @Override
    public void end() {
        if (this.m_handler != null) {
            try {
                this.m_handler.endElement("", "", "systemReportPlugins");
                this.m_handler.endDocument();
            }
            catch (Exception e) {
                LOG.warn("Unable to end document.", (Throwable)e);
            }
        }
    }
}

