/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class TopReportPlugin
extends AbstractSystemReportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TopReportPlugin.class);

    @Override
    public String getName() {
        return "Top";
    }

    @Override
    public String getDescription() {
        return "Output of the 'top' command (full output only)";
    }

    @Override
    public int getPriority() {
        return 11;
    }

    @Override
    public Map<String, Resource> getEntries() {
        File tempFile;
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        String top = this.getResourceLocator().findBinary("top");
        String topOutput = null;
        if (top != null) {
            String topcmd;
            topOutput = this.getResourceLocator().slurpOutput(top + " -h", true);
            LOG.debug("top -h output: {}", (Object)topOutput);
            if (topOutput.contains("-b") && topOutput.contains("-n")) {
                topcmd = top + " -n 1 -b";
                LOG.trace("calling: {}", (Object)topcmd);
                topOutput = this.getResourceLocator().slurpOutput(topcmd, false);
            } else if (topOutput.contains("-l")) {
                topcmd = top + " -l 1";
                LOG.trace("calling: {}", (Object)topcmd);
                topOutput = this.getResourceLocator().slurpOutput(topcmd, false);
            } else {
                topOutput = null;
            }
        }
        if (topOutput != null && (tempFile = this.createTemporaryFileFromString(topOutput)) != null) {
            map.put("Output", (Resource)new FileSystemResource(tempFile));
        }
        return map;
    }
}

