/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.TreeMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ThreadReportPlugin
extends AbstractSystemReportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadReportPlugin.class);

    @Override
    public String getName() {
        return "Threads";
    }

    @Override
    public String getDescription() {
        return "Java thread dump (full output only)";
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        StringBuilder sb = new StringBuilder();
        try {
            ThreadInfo[] threads;
            for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                sb.append(info.toString());
            }
            map.put("ThreadDump.txt", this.getResource(sb.toString()));
        }
        catch (Exception e) {
            LOG.debug("Unable to get thread dump.", (Throwable)e);
        }
        return map;
    }

    private void triggerThreadDump() {
        String kill = this.findBinary("kill");
        if (kill != null) {
            for (Integer pid : this.getOpenNMSProcesses()) {
                LOG.debug("pid = {}", (Object)pid);
                CommandLine command = CommandLine.parse((String)(kill + " -3 " + pid.toString()));
                try {
                    LOG.trace("running '{}'", (Object)command);
                    DefaultExecutor executor = new DefaultExecutor();
                    executor.setWatchdog(new ExecuteWatchdog(5000L));
                    int exitValue = executor.execute(command);
                    LOG.trace("finished '{}'", (Object)command);
                    if (exitValue == 0) continue;
                    LOG.warn("'{}' exited non-zero: {}", (Object)command, (Object)exitValue);
                }
                catch (Exception e) {
                    LOG.warn("Unable to run kill -3 on '{}': you might need to run system-report as root.", (Object)pid, (Object)e);
                }
            }
        }
    }
}

