/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.opennms.bootstrap.Bootstrap;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SystemReport
extends Bootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(SystemReport.class);
    static final Pattern m_pattern = Pattern.compile("^-D(.*?)=(.*)$");
    private ServiceRegistry m_serviceRegistry;
    private String m_output = "-";
    private String m_format = "text";

    public static void main(String[] args) throws Exception {
        SystemReport.loadDefaultProperties();
        SystemReport.executeClass((String)"org.opennms.systemreport.SystemReport", (String)"report", (String[])args, (boolean)true, (boolean)true);
    }

    public static void report(String[] args) throws Exception {
        String value;
        String tempdir = System.getProperty("java.io.tmpdir");
        for (String arg : args) {
            Matcher m;
            if (!arg.startsWith("-D") || !arg.contains("=") || !(m = m_pattern.matcher(arg)).matches()) continue;
            System.setProperty(m.group(1), m.group(2));
        }
        if (System.getProperty("opennms.home") == null) {
            System.setProperty("opennms.home", tempdir);
        }
        if (System.getProperty("rrd.base.dir") == null) {
            System.setProperty("rrd.base.dir", tempdir);
        }
        if (System.getProperty("rrd.binary") == null) {
            System.setProperty("rrd.binary", "/usr/bin/rrdtool");
        }
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "this help");
        options.addOption("D", "define", true, "define a java property");
        options.addOption("p", "list-plugins", false, "list the available system report plugins");
        options.addOption("u", "use-plugins", true, "select the plugins to output");
        options.addOption("l", "list-formats", false, "list the available output formats");
        options.addOption("f", "format", true, "the format to output");
        options.addOption("o", "output", true, "the file to write output to");
        CommandLine line = parser.parse(options, args, false);
        LinkedHashSet<String> plugins = new LinkedHashSet<String>();
        SystemReport report = new SystemReport();
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("system-report.sh [options]", options);
            System.exit(0);
        }
        if (line.hasOption("f")) {
            report.setFormat(line.getOptionValue("f"));
        }
        if (line.hasOption("o")) {
            report.setOutput(line.getOptionValue("o"));
        }
        if (line.hasOption("u") && (value = line.getOptionValue("u")) != null) {
            for (String s : value.split(",+")) {
                plugins.add(s);
            }
        }
        if (line.hasOption("p")) {
            report.listPlugins();
        } else if (line.hasOption("l")) {
            report.listFormats();
        } else {
            report.writePluginData(plugins);
        }
    }

    private void setOutput(String file) {
        this.m_output = file;
    }

    private void setFormat(String format) {
        this.m_format = format;
    }

    private void writePluginData(Collection<String> plugins) {
        this.initializeSpring();
        SystemReportFormatter formatter = null;
        for (SystemReportFormatter systemReportFormatter : this.getFormatters()) {
            if (!this.m_format.equals(systemReportFormatter.getName())) continue;
            formatter = systemReportFormatter;
            break;
        }
        if (formatter == null) {
            LOG.error("Unknown format '{}'!", (Object)this.m_format);
            System.exit(1);
        }
        formatter.setOutput(this.m_output);
        OutputStream stream = null;
        if (formatter.needsOutputStream()) {
            if (this.m_output.equals("-")) {
                stream = System.out;
            } else {
                try {
                    File file = new File(this.m_output);
                    if (!file.delete()) {
                        LOG.warn("Could not delete file: {}", (Object)file.getPath());
                    }
                    stream = new FileOutputStream(file, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOG.error("Unable to write to '{}'", (Object)this.m_output, (Object)fileNotFoundException);
                    System.exit(1);
                }
            }
            if (this.m_output.equals("-") && !formatter.canStdout()) {
                LOG.error("{} formatter does not support writing to STDOUT!", (Object)formatter.getName());
                System.exit(1);
            }
            formatter.setOutputStream(stream);
        }
        int n = plugins.size();
        HashMap<String, SystemReportPlugin> pluginMap = new HashMap<String, SystemReportPlugin>();
        for (SystemReportPlugin plugin : this.getPlugins()) {
            String name = plugin.getName();
            if (n == 0) {
                plugins.add(name);
            }
            pluginMap.put(name, plugin);
        }
        try {
            formatter.begin();
            if (stream != null) {
                stream.flush();
            }
            for (String pluginName : plugins) {
                SystemReportPlugin plugin = (SystemReportPlugin)pluginMap.get(pluginName);
                if (plugin == null) {
                    LOG.warn("No plugin named '{}' found, skipping.", (Object)pluginName);
                    continue;
                }
                try {
                    formatter.write(plugin);
                }
                catch (Exception e) {
                    LOG.error("An error occurred calling plugin '{}'", (Object)plugin.getName(), (Object)e);
                }
                if (stream == null) continue;
                stream.flush();
            }
            formatter.end();
            if (stream != null) {
                stream.flush();
            }
        }
        catch (Exception e) {
            LOG.error("An error occurred writing plugin data to output.", (Throwable)e);
            System.exit(1);
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    private void listPlugins() {
        for (SystemReportPlugin plugin : this.getPlugins()) {
            System.err.println(plugin.getName() + ": " + plugin.getDescription());
        }
    }

    private void listFormats() {
        for (SystemReportFormatter formatter : this.getFormatters()) {
            System.err.println(formatter.getName() + ": " + formatter.getDescription());
        }
    }

    public List<SystemReportPlugin> getPlugins() {
        this.initializeSpring();
        ArrayList<SystemReportPlugin> plugins = new ArrayList<SystemReportPlugin>(this.m_serviceRegistry.findProviders(SystemReportPlugin.class));
        Collections.sort(plugins);
        return plugins;
    }

    public List<SystemReportFormatter> getFormatters() {
        this.initializeSpring();
        ArrayList<SystemReportFormatter> formatters = new ArrayList<SystemReportFormatter>(this.m_serviceRegistry.findProviders(SystemReportFormatter.class));
        Collections.sort(formatters);
        return formatters;
    }

    private void initializeSpring() {
        if (this.m_serviceRegistry == null) {
            ArrayList<String> configs = new ArrayList<String>();
            configs.add("classpath:/META-INF/opennms/applicationContext-soa.xml");
            configs.add("classpath:/META-INF/opennms/applicationContext-dao.xml");
            configs.add("classpath*:/META-INF/opennms/component-dao.xml");
            configs.add("classpath:/META-INF/opennms/applicationContext-systemReport.xml");
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configs.toArray(new String[0]));
            this.m_serviceRegistry = (ServiceRegistry)context.getBean("serviceRegistry");
        }
    }

    public void setServiceRegistry(ServiceRegistry registry) {
        this.m_serviceRegistry = registry;
    }
}

