/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.opennms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeMap;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class OpenNMSReportPlugin
extends AbstractSystemReportPlugin
implements InitializingBean {
    @Autowired
    public NodeDao m_nodeDao;
    @Autowired
    public IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    public SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    public EventDao m_eventDao;
    @Autowired
    public AlarmDao m_alarmDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    public String getName() {
        return "OpenNMS";
    }

    @Override
    public String getDescription() {
        return "OpenNMS core information, version, and basic configuration";
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        InputStream is = this.getClass().getResourceAsStream("/version.properties");
        if (is != null) {
            Properties p = new Properties();
            try {
                p.load(is);
                map.put("Version", this.getResource(p.getProperty("version.display")));
            }
            catch (IOException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to load from version.properties", (Object[])new Object[0]);
            }
        }
        if (this.m_nodeDao != null) {
            map.put("Number of Nodes", this.getResource(Integer.toString(this.m_nodeDao.countAll())));
        }
        if (this.m_ipInterfaceDao != null) {
            map.put("Number of IP Interfaces", this.getResource(Integer.toString(this.m_ipInterfaceDao.countAll())));
        }
        if (this.m_snmpInterfaceDao != null) {
            map.put("Number of SNMP Interfaces", this.getResource(Integer.toString(this.m_snmpInterfaceDao.countAll())));
        }
        if (this.m_eventDao != null) {
            map.put("Number of Events", this.getResource(Integer.toString(this.m_eventDao.countAll())));
        }
        if (this.m_alarmDao != null) {
            map.put("Number of Alarms", this.getResource(Integer.toString(this.m_alarmDao.countAll())));
        }
        return map;
    }
}

