/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractSystemReportFormatter
implements SystemReportFormatter {
    protected OutputStream m_outputStream = null;
    private String m_output;

    protected String getOutput() {
        return this.m_output;
    }

    @Override
    public void setOutput(String output) {
        this.m_output = output;
    }

    protected OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.m_outputStream = stream;
    }

    @Override
    public boolean needsOutputStream() {
        return true;
    }

    @Override
    public String getName() {
        LogUtils.warnf((Object)this, (String)"Plugin did not implement getFormatName()! Using the class name: %s", (Object[])new Object[]{this.getClass().getName()});
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        LogUtils.warnf((Object)this, (String)"Plugin %s did not implement getDescription()! Using the format name.", (Object[])new Object[]{this.getName()});
        return this.getName();
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        LogUtils.warnf((Object)this, (String)"Plugin %s did not implement write()! No data was written.", (Object[])new Object[]{this.getName()});
    }

    @Override
    public void begin() {
        if (this.needsOutputStream() && this.m_outputStream == null) {
            LogUtils.errorf((Object)this, (String)"The output stream is not set and this formatter requires an output stream.", (Object[])new Object[0]);
        }
    }

    @Override
    public void end() {
    }

    @Override
    public final int compareTo(SystemReportFormatter o) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)(o == null ? null : o.getName())).append((Object)this.getDescription(), (Object)(o == null ? null : o.getDescription())).toComparison();
    }

    protected boolean isDisplayable(Resource r) {
        return r instanceof ByteArrayResource;
    }

    protected boolean isFile(Resource r) {
        return r instanceof FileSystemResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceText(Resource r) {
        BufferedReader br;
        InputStreamReader isr;
        InputStream is;
        block6: {
            String string;
            if (r instanceof ByteArrayResource) {
                return new String(((ByteArrayResource)r).getByteArray());
            }
            is = null;
            isr = null;
            br = null;
            try {
                is = r.getInputStream();
                if (is == null) break block6;
                StringBuilder sb = new StringBuilder();
                String line = null;
                isr = new InputStreamReader(is, Charset.defaultCharset());
                br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                sb.deleteCharAt(sb.length());
                string = sb.toString();
            }
            catch (IOException e) {
                String string2;
                try {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to get inputstream for resource '%s'", (Object[])new Object[]{r});
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(isr);
                    IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly((Reader)isr);
                IOUtils.closeQuietly((InputStream)is);
                return string2;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(isr);
        IOUtils.closeQuietly((InputStream)is);
        return null;
    }

    protected boolean hasDisplayable(SystemReportPlugin plugin) {
        for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
            if (!this.isDisplayable(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

