/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.opennms;

import java.util.Set;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.opennms.systemreport.dao.CountedObject;
import org.opennms.systemreport.dao.EventCountDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class TopEventReportPlugin
extends AbstractSystemReportPlugin {
    @Autowired
    public EventCountDao m_eventCountDao;

    @Override
    public String getName() {
        return "TopEvent";
    }

    @Override
    public String getDescription() {
        return "Top 20 most reported events";
    }

    @Override
    public int getPriority() {
        return 4;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        if (this.m_eventCountDao != null) {
            Set<CountedObject<String>> objs = this.m_eventCountDao.getUeiCounts(20);
            for (CountedObject<String> obj : objs) {
                map.put(obj.getObject(), (Resource)new ByteArrayResource(obj.getCount().toString().getBytes()));
            }
        }
        return map;
    }
}

