/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;

public class RequestAttributePreAuthenticationProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAttributePreAuthenticationProcessingFilter.class);
    private boolean m_enabled = false;
    private String m_principalRequestAttribute = null;
    private String m_credentialsRequestAttribute = null;
    private boolean m_failOnError = false;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.m_enabled) {
            if (StringUtils.isBlank((String)this.m_principalRequestAttribute)) {
                throw new IllegalStateException("RequestAttributePreAuthenticationProcessingFilter is enabled but 'principalRequestHeader' is not set!");
            }
            if (StringUtils.isBlank((String)this.m_credentialsRequestAttribute)) {
                this.m_credentialsRequestAttribute = null;
            }
            LOG.debug("Request attribute pre-authentication filter is enabled.  Access will be pre-authenticated by the user (principal) in the '{}' attribute on each servlet request.", (Object)this.m_principalRequestAttribute);
        } else {
            LOG.info("Request attribute pre-authentication filter is disabled.");
        }
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (this.m_enabled) {
            Object user = request.getAttribute(this.m_principalRequestAttribute);
            if (user == null && this.m_failOnError) {
                throw new PreAuthenticatedCredentialsNotFoundException(this.m_principalRequestAttribute + " attribute not found in request.");
            }
            return user;
        }
        return null;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        if (this.m_credentialsRequestAttribute != null) {
            return request.getAttribute(this.m_credentialsRequestAttribute);
        }
        return "";
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setPrincipalRequestHeader(String principleRequestAttribute) {
        this.m_principalRequestAttribute = principleRequestAttribute;
    }

    public void setCredentialsRequestHeader(String credentialsRequestAttribute) {
        this.m_credentialsRequestAttribute = credentialsRequestAttribute;
    }

    public void setFailOnError(boolean failOnError) {
        this.m_failOnError = failOnError;
    }
}

