/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;

public class RequestHeaderPreAuthenticationProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHeaderPreAuthenticationProcessingFilter.class);
    private boolean m_enabled = false;
    private String m_userHeader = null;
    private String m_credentialsHeader = null;
    private boolean m_failOnError = false;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.m_enabled) {
            if (StringUtils.isBlank((String)this.m_userHeader)) {
                throw new IllegalStateException("RequestHeaderPreAuthenticationProcessingFilter is enabled but 'userHeader' is not set!");
            }
            if (StringUtils.isBlank((String)this.m_credentialsHeader)) {
                this.m_credentialsHeader = null;
            }
            LOG.debug("Request header pre-authentication filter is enabled.  Access will be pre-authenticated by the user (principal) in the '{}' header on each servlet request.", (Object)this.m_userHeader);
        } else {
            LOG.info("Request header pre-authentication filter is disabled.");
        }
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (this.m_enabled) {
            String user = request.getHeader(this.m_userHeader);
            if (user == null && this.m_failOnError) {
                throw new PreAuthenticatedCredentialsNotFoundException(this.m_userHeader + " header not found in request.");
            }
            return user;
        }
        return null;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        if (this.m_credentialsHeader != null) {
            return request.getHeader(this.m_credentialsHeader);
        }
        return "";
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setUserHeader(String userHeader) {
        this.m_userHeader = userHeader;
    }

    public void setCredentialsHeader(String credentialsHeader) {
        this.m_credentialsHeader = credentialsHeader;
    }

    public void setFailOnError(boolean failOnError) {
        this.m_failOnError = failOnError;
    }
}

