/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.opennms.bootstrap.OpenNMSProxyLoginModule;
import org.opennms.core.sysprops.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSConfiguration
extends Configuration {
    private static volatile Logger LOG = LoggerFactory.getLogger(OpenNMSConfiguration.class);
    private static final String JAAS_TIMEOUT_SYS_PROP = "org.opennms.web.springframework.security.jaas-timeout";
    private static final long DEFAULT_JAAS_TIMEOUT_MS = 120000L;
    private final Set<Configuration> m_delegates = new LinkedHashSet<Configuration>();

    public void init() throws InterruptedException {
        LOG.debug("OpenNMSConfiguration initializing.");
        new Thread(new Runnable(){

            @Override
            public void run() {
                long giveUp = System.currentTimeMillis() + SystemProperties.getLong((String)OpenNMSConfiguration.JAAS_TIMEOUT_SYS_PROP, (Long)120000L);
                do {
                    Configuration c;
                    if ((c = Configuration.getConfiguration()) != null && OpenNMSConfiguration.this.m_delegates.add(c)) {
                        LOG.trace("OpenNMSConfiguration found existing configuration: " + c.getClass().getName());
                        if (c.getClass().getName().contains("OsgiConfiguration")) {
                            LOG.debug("Found Karaf OSGi JAAS configuration.  Inserting OpenNMS redirector.");
                            break;
                        }
                    }
                    LOG.trace("OpenNMSConfiguration still waiting for Karaf OsgiConfiguration to activate...");
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while waiting for Karaf's OSGi Configuration to initialize.", (Throwable)e);
                        break;
                    }
                } while (System.currentTimeMillis() < giveUp);
                Configuration.setConfiguration(OpenNMSConfiguration.this);
            }
        }).start();
    }

    public void close() {
        Iterator<Configuration> it = this.m_delegates.iterator();
        Configuration.setConfiguration(it.hasNext() ? it.next() : null);
        this.m_delegates.clear();
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        LOG.debug("getAppConfigurationEntry(" + name + ")");
        if ("opennms".equals(name)) {
            LOG.debug("getAppConfigurationEntry: Overriding.");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(OpenNMSProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap())};
        }
        LOG.debug("getAppConfigurationEntry: Passing through.");
        return this.m_delegates.stream().map(c -> c.getAppConfigurationEntry(name)).reduce(null, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            AppConfigurationEntry[] c = new AppConfigurationEntry[((AppConfigurationEntry[])a).length + ((AppConfigurationEntry[])b).length];
            System.arraycopy(a, 0, c, 0, ((AppConfigurationEntry[])a).length);
            System.arraycopy(b, 0, c, ((AppConfigurationEntry[])a).length, ((AppConfigurationEntry[])b).length);
            return c;
        });
    }

    @Override
    public void refresh() {
        this.m_delegates.stream().forEach(Configuration::refresh);
    }
}

