/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Collection;
import java.util.Iterator;
import org.opennms.web.api.SecurityContextService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SpringSecurityContextService
implements SecurityContextService {
    private SecurityContext m_context = SecurityContextHolder.getContext();

    public String getUsername() {
        return this.getUserDetails().getUsername();
    }

    public String getPassword() {
        return this.getUserDetails().getPassword();
    }

    private UserDetails getUserDetails() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            return (UserDetails)principal;
        }
        throw new IllegalStateException("principal should always be instanceof UserDetails");
    }

    public boolean hasRole(String role) {
        Collection authorities;
        boolean hasRole = false;
        UserDetails userDetails = this.getUserDetails();
        if (userDetails != null && this.isRolePresent(authorities = userDetails.getAuthorities(), role)) {
            hasRole = true;
        }
        return hasRole;
    }

    public boolean isAuthenticated() {
        return this.m_context.getAuthentication().isAuthenticated();
    }

    private boolean isRolePresent(Collection<? extends GrantedAuthority> authorities, String role) {
        GrantedAuthority grantedAuthority;
        boolean isRolePresent = false;
        Iterator<? extends GrantedAuthority> iterator = authorities.iterator();
        while (iterator.hasNext() && !(isRolePresent = (grantedAuthority = iterator.next()).getAuthority().equals(role))) {
        }
        return isRolePresent;
    }
}

