/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.util.Assert;

public class AntPatternBasedAuthenticationEntryPointChain
implements AuthenticationEntryPoint,
InitializingBean {
    private List<String> m_patterns;
    private AuthenticationEntryPoint m_matchingEntryPoint;
    private AuthenticationEntryPoint m_nonMatchingEntryPoint;

    public void setPatterns(List<String> patterns) {
        this.m_patterns = patterns;
    }

    public void setMatchingEntryPoint(AuthenticationEntryPoint matchedEntryPoint) {
        this.m_matchingEntryPoint = matchedEntryPoint;
    }

    public void setNonMatchingEntryPoint(AuthenticationEntryPoint unmatchedEntryPoint) {
        this.m_nonMatchingEntryPoint = unmatchedEntryPoint;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nonMatchingEntryPoint, (String)"nonMatchingEntryPoint may not be null");
        Assert.notNull((Object)this.m_matchingEntryPoint, (String)"matchingEntryPoint may not be null");
        Assert.notNull(this.m_patterns, (String)"patterns may not be null");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        AuthenticationEntryPoint entryPoint = this.getAppropriateEntryPoint(request);
        entryPoint.commence(request, response, authException);
    }

    private AuthenticationEntryPoint getAppropriateEntryPoint(HttpServletRequest request) {
        for (String pattern : this.m_patterns) {
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(pattern);
            if (!matcher.matches(request)) continue;
            return this.m_matchingEntryPoint;
        }
        return this.m_nonMatchingEntryPoint;
    }
}

