/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.opennms.netmgt.config.api.UserConfig;
import org.opennms.web.springframework.security.AuthorityPrincipal;
import org.opennms.web.springframework.security.LoginHandler;
import org.opennms.web.springframework.security.LoginModuleUtils;
import org.opennms.web.springframework.security.OpenNMSLoginHandler;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class OpenNMSLoginModule
implements LoginModule,
LoginHandler,
OpenNMSLoginHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenNMSLoginModule.class);
    private static volatile transient UserConfig m_userConfig;
    private static volatile transient SpringSecurityUserDao m_springSecurityUserDao;
    protected Subject m_subject;
    protected CallbackHandler m_callbackHandler;
    protected Map<String, ?> m_sharedState;
    protected Map<String, ?> m_options;
    protected String m_user;
    protected Set<Principal> m_principals = new HashSet<Principal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        LOG.info("OpenNMS Login Module initializing.");
        this.m_subject = subject;
        this.m_callbackHandler = callbackHandler;
        this.m_sharedState = sharedState;
        this.m_options = options;
    }

    @Override
    public boolean login() throws LoginException {
        return LoginModuleUtils.doLogin(this, this.m_subject, this.m_sharedState, this.m_options);
    }

    @Override
    public boolean abort() throws LoginException {
        LOG.debug("Aborting {} login.", (Object)this.m_user);
        this.m_user = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        LOG.debug("Logging out user {}.", (Object)this.m_user);
        this.m_subject.getPrincipals().removeAll(this.m_principals);
        this.m_principals.clear();
        return true;
    }

    public static synchronized UserConfig getUserConfig() {
        return m_userConfig;
    }

    public static synchronized void setUserConfig(UserConfig userConfig) {
        m_userConfig = userConfig;
    }

    public static synchronized SpringSecurityUserDao getSpringSecurityUserDao() {
        return m_springSecurityUserDao;
    }

    public static synchronized void setSpringSecurityUserDao(SpringSecurityUserDao userDao) {
        m_springSecurityUserDao = userDao;
    }

    @Override
    public boolean commit() throws LoginException {
        Set<Principal> principals = this.principals();
        if (principals.isEmpty()) {
            return false;
        }
        this.m_subject.getPrincipals().addAll(principals);
        return true;
    }

    @Override
    public CallbackHandler callbackHandler() {
        return this.m_callbackHandler;
    }

    @Override
    public UserConfig userConfig() {
        return m_userConfig;
    }

    @Override
    public SpringSecurityUserDao springSecurityUserDao() {
        return m_springSecurityUserDao;
    }

    @Override
    public String user() {
        return this.m_user;
    }

    @Override
    public void setUser(String user) {
        this.m_user = user;
    }

    @Override
    public Set<Principal> createPrincipals(GrantedAuthority authority) {
        return Collections.singleton(new AuthorityPrincipal(authority));
    }

    @Override
    public Set<Principal> principals() {
        return this.m_principals;
    }

    @Override
    public void setPrincipals(Set<Principal> principals) {
        this.m_principals = principals;
    }

    @Override
    public boolean requiresAdminRole() {
        return false;
    }
}

