/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class UserGroupLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupLdapAuthoritiesPopulator.class);
    private final SearchControls searchControls = new SearchControls();
    private final SpringSecurityLdapTemplate ldapTemplate;
    private String groupRoleAttribute = "cn";
    private String groupSearchFilter = "(member={0})";
    private Map<String, List<String>> groupToRoleMap = new HashMap<String, List<String>>();

    public UserGroupLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        super(contextSource, groupSearchBase);
        this.ldapTemplate = new SpringSecurityLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
        String userDn = user.getNameInNamespace();
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        if (super.getGroupSearchBase() == null) {
            return authorities;
        }
        LOG.debug("Searching for roles for user '{}', DN = '{}', with filter '{}' in search base '{}'", new Object[]{username, userDn, this.groupSearchFilter, super.getGroupSearchBase()});
        Set userRoles = this.ldapTemplate.searchForSingleAttributeValues(super.getGroupSearchBase(), this.groupSearchFilter, (Object[])new String[]{userDn, username}, this.groupRoleAttribute);
        userRoles.add("");
        for (String group : userRoles) {
            List<String> rolesForGroup = this.groupToRoleMap.get(group);
            LOG.debug("Checking {} for an associated role", (Object)group);
            if (rolesForGroup == null) continue;
            for (String role : rolesForGroup) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
                LOG.debug("Added role: {} based on group {}", (Object)role, (Object)group);
            }
        }
        return authorities;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        super.setGroupRoleAttribute(groupRoleAttribute);
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        super.setGroupSearchFilter(groupSearchFilter);
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setGroupToRoleMap(Map<String, List<String>> groupToRoleMap) {
        this.groupToRoleMap = groupToRoleMap;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        super.setSearchSubtree(searchSubtree);
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }
}

