/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Collections;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.opennms.bootstrap.OpenNMSProxyLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSConfiguration
extends Configuration {
    private static volatile Logger LOG = LoggerFactory.getLogger(OpenNMSConfiguration.class);
    Configuration m_parentConfiguration;

    public void init() throws InterruptedException {
        LOG.debug("OpenNMSConfiguration initializing.");
        new Thread(new Runnable(){

            @Override
            public void run() {
                long giveUp = System.currentTimeMillis() + Long.getLong("org.opennms.web.springframework.security.jaas-timeout", 120000L);
                do {
                    Configuration c;
                    if ((c = Configuration.getConfiguration()) != null) {
                        LOG.trace("OpenNMSConfiguration found existing configuration: " + c.getClass().getName());
                        if (c.getClass().getName().contains("OsgiConfiguration")) {
                            LOG.debug("Found Karaf OSGi JAAS configuration.  Inserting OpenNMS redirector.");
                            break;
                        }
                    }
                    LOG.trace("OpenNMSConfiguration still waiting for Karaf OsgiConfiguration to activate...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while waiting for Karaf's OSGi Configuration to initialize.", (Throwable)e);
                    }
                } while (System.currentTimeMillis() < giveUp);
                OpenNMSConfiguration.this.m_parentConfiguration = Configuration.getConfiguration();
                Configuration.setConfiguration(OpenNMSConfiguration.this);
            }
        }).start();
    }

    public void close() {
        Configuration.setConfiguration(this.m_parentConfiguration);
        this.m_parentConfiguration = null;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        LOG.debug("getAppConfigurationEntry(" + name + ")");
        if ("opennms".equals(name)) {
            LOG.debug("getAppConfigurationEntry: Overriding.");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(OpenNMSProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap())};
        }
        LOG.debug("getAppConfigurationEntry: Passing through to Karaf.");
        if (this.m_parentConfiguration != null) {
            return this.m_parentConfiguration.getAppConfigurationEntry(name);
        }
        return null;
    }

    @Override
    public void refresh() {
        if (this.m_parentConfiguration != null) {
            this.m_parentConfiguration.refresh();
        }
    }
}

