/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.util.Assert;

public class RequestAttributePreAuthenticationProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private String m_principalRequestAttribute = "REMOTE_USER";
    private String m_credentialsRequestAttribute;

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Object principal = request.getAttribute(this.m_principalRequestAttribute);
        if (principal == null) {
            throw new PreAuthenticatedCredentialsNotFoundException(this.m_principalRequestAttribute + " attribute not found in request.");
        }
        return principal;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        if (this.m_credentialsRequestAttribute != null) {
            Object credentials = request.getAttribute(this.m_credentialsRequestAttribute);
            return credentials;
        }
        return "";
    }

    public void setPrincipalRequestHeader(String principalRequestAttribute) {
        Assert.hasText((String)principalRequestAttribute, (String)"principalRequestAttribute must not be empty or null");
        this.m_principalRequestAttribute = principalRequestAttribute;
    }

    public void setCredentialsRequestHeader(String credentialsRequestAttribute) {
        Assert.hasText((String)credentialsRequestAttribute, (String)"credentialsRequestAttribute must not be empty or null");
        this.m_credentialsRequestAttribute = credentialsRequestAttribute;
    }
}

