/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.BundleLists;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.web.api.Authentication;
import org.opennms.web.springframework.security.SpringSecurityUser;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

public class SpringSecurityUserDaoImpl
implements SpringSecurityUserDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SpringSecurityUserDaoImpl.class);
    private UserManager m_userManager;
    private GroupManager m_groupManager;
    private String m_usersConfigurationFile;
    private String m_groupsConfigurationFile;
    private Map<String, OnmsUser> m_users = null;
    private long m_usersLastModified;
    private String m_magicUsersConfigurationFile;
    private Map<String, OnmsUser> m_magicUsers = null;
    private Map<String, Collection<? extends GrantedAuthority>> m_roles = null;
    private Map<String, GrantedAuthority> m_authorities = new HashMap<String, GrantedAuthority>();
    private long m_magicUsersLastModified;
    private long m_groupsLastModified;
    private boolean m_useGroups;

    private void parseUsers() throws DataRetrievalFailureException {
        HashMap<String, OnmsUser> users = new HashMap<String, OnmsUser>();
        try {
            for (OnmsUser user : this.m_userManager.getOnmsUserList()) {
                users.put(user.getUsername(), user);
            }
        }
        catch (Throwable t) {
            throw new DataRetrievalFailureException("Unable to get user list.", t);
        }
        LOG.debug("Loaded the users.xml file with {} users", (Object)users.size());
        this.m_usersLastModified = this.m_userManager.getLastModified();
        this.m_users = users;
    }

    private Map<String, LinkedList<String>> parseGroupRoles() throws DataRetrievalFailureException {
        long lastModified = new File(this.m_groupsConfigurationFile).lastModified();
        HashMap<String, LinkedList<String>> roleMap = new HashMap<String, LinkedList<String>>();
        Collection roles = this.m_groupManager.getRoles();
        for (Role role : roles) {
            List users;
            String groupname = role.getMembershipGroup();
            String securityRole = Authentication.getSpringSecurityRoleFromOldRoleName((String)role.getName());
            if (securityRole == null) continue;
            try {
                users = this.m_groupManager.getGroup(groupname).getUserCollection();
            }
            catch (Throwable e) {
                throw new DataRetrievalFailureException("Error reading groups configuration file '" + this.m_groupsConfigurationFile + "': " + e.getMessage(), e);
            }
            for (String user : users) {
                if (roleMap.get(user) == null) {
                    roleMap.put(user, new LinkedList());
                }
                LinkedList userRoleList = (LinkedList)roleMap.get(user);
                userRoleList.add(securityRole);
            }
        }
        LOG.debug("Loaded roles from groups.xml file for {} users", (Object)roleMap.size());
        this.m_groupsLastModified = lastModified;
        return roleMap;
    }

    public void parseMagicUsers() throws DataRetrievalFailureException {
        String[] configuredUsers;
        HashMap<String, OnmsUser> magicUsers = new HashMap<String, OnmsUser>();
        HashMap<String, Collection<? extends GrantedAuthority>> roles = new HashMap<String, Collection<? extends GrantedAuthority>>();
        long lastModified = new File(this.m_magicUsersConfigurationFile).lastModified();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.m_magicUsersConfigurationFile));
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Magic users configuration file '" + this.m_magicUsersConfigurationFile + "' not found: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error reading magic users configuration file '" + this.m_magicUsersConfigurationFile + "': " + e.getMessage(), (Throwable)e);
        }
        for (String user : configuredUsers = BundleLists.parseBundleList((String)properties.getProperty("users"))) {
            String string = properties.getProperty("user." + user + ".username");
            String password = properties.getProperty("user." + user + ".password");
            OnmsUser newUser = null;
            try {
                newUser = this.m_userManager.getOnmsUser(user);
            }
            catch (Exception ioe) {
                throw new DataRetrievalFailureException("Unable to read user " + user + " from users.xml", (Throwable)ioe);
            }
            if (newUser == null) {
                newUser = new OnmsUser();
                newUser.setUsername(string);
                newUser.setPassword(this.m_userManager.encryptedPassword(password, true));
                newUser.setPasswordSalted(Boolean.valueOf(true));
            }
            magicUsers.put(string, newUser);
        }
        String[] configuredRoles = BundleLists.parseBundleList((String)properties.getProperty("roles"));
        HashMap roleMap = this.m_useGroups ? this.parseGroupRoles() : new HashMap();
        HashMap<String, Boolean> roleAddDefaultMap = new HashMap<String, Boolean>();
        for (String role : configuredRoles) {
            String rolename = properties.getProperty("role." + role + ".name");
            if (rolename == null) {
                LOG.warn("Role configuration for '{}' does not have 'name' parameter.  Expecting a 'role.{}.name' property. The role will not be usable.", (Object)role, (Object)role);
                continue;
            }
            String userList = properties.getProperty("role." + role + ".users");
            if (userList == null) {
                LOG.warn("Role configuration for '{}' does not have 'users' parameter.  Expecting a 'role.{}.users' property. The role will not be usable.", (Object)role, (Object)role);
                continue;
            }
            String[] authUsers = BundleLists.parseBundleList((String)userList);
            boolean notInDefaultGroup = "true".equals(properties.getProperty("role." + role + ".notInDefaultGroup"));
            String securityRole = Authentication.getSpringSecurityRoleFromOldRoleName((String)rolename);
            if (securityRole == null) {
                throw new DataRetrievalFailureException("Could not find Spring Security role mapping for old role name '" + rolename + "' for role '" + role + "'");
            }
            for (String authUser : authUsers) {
                if (roleMap.get(authUser) == null) {
                    roleMap.put(authUser, new LinkedList());
                }
                LinkedList userRoleList = (LinkedList)roleMap.get(authUser);
                userRoleList.add(securityRole);
            }
            roleAddDefaultMap.put(securityRole, !notInDefaultGroup);
        }
        for (Map.Entry entry : roleMap.entrySet()) {
            roles.put((String)entry.getKey(), this.getAuthorityListFromRoleList((List)entry.getValue(), roleAddDefaultMap));
        }
        LOG.debug("Loaded the magic-users.properties file with {} magic users, {} roles, and {} user roles", new Object[]{magicUsers.size(), configuredRoles.length, roles.size()});
        this.m_magicUsersLastModified = lastModified;
        this.m_magicUsers = magicUsers;
        this.m_roles = roles;
    }

    private Collection<? extends GrantedAuthority> getAuthorityListFromRoleList(List<String> roleList, Map<String, Boolean> roleAddDefaultMap) {
        boolean addToDefaultGroup = false;
        for (String role : roleList) {
            if (!Boolean.TRUE.equals(roleAddDefaultMap.get(role))) continue;
            addToDefaultGroup = true;
            break;
        }
        LinkedList<GrantedAuthority> authorities = new LinkedList<GrantedAuthority>();
        if (addToDefaultGroup) {
            authorities.add(ROLE_USER);
        }
        for (String role : roleList) {
            authorities.add(this.getAuthority(role));
        }
        return authorities;
    }

    protected GrantedAuthority getAuthority(String role) {
        if (!this.m_authorities.containsKey(role)) {
            this.m_authorities.put(role, (GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        return this.m_authorities.get(role);
    }

    protected Collection<? extends GrantedAuthority> getAuthoritiesByUsername(String username) {
        if (this.m_roles.containsKey(username)) {
            Collection<? extends GrantedAuthority> roles = this.m_roles.get(username);
            LOG.debug("User {} has roles: {}", (Object)username, roles);
            return roles;
        }
        List<GrantedAuthority> roles = Arrays.asList(ROLE_USER);
        LOG.debug("User {} has roles: {}", (Object)username, roles);
        return roles;
    }

    private boolean isUsersParseNecessary() {
        if (this.m_users == null) {
            return true;
        }
        return this.m_usersLastModified != this.m_userManager.getLastModified();
    }

    private boolean isGroupsParseNecessary() {
        return this.m_groupsLastModified != new File(this.m_groupsConfigurationFile).lastModified();
    }

    private boolean isMagicUsersParseNecessary() {
        if (this.m_magicUsers == null) {
            return true;
        }
        return this.m_magicUsersLastModified != new File(this.m_magicUsersConfigurationFile).lastModified();
    }

    public void setUsersConfigurationFile(String usersConfigurationFile) {
        this.m_usersConfigurationFile = usersConfigurationFile;
        UserFactory.setInstance(null);
    }

    public void setGroupsConfigurationFile(String groupsConfigurationFile) {
        this.m_groupsConfigurationFile = groupsConfigurationFile;
        GroupFactory.setInstance(null);
    }

    public void setUseGroups(boolean useGroups) {
        this.m_useGroups = useGroups;
    }

    public String getUsersConfigurationFile() {
        return this.m_usersConfigurationFile;
    }

    public void setMagicUsersConfigurationFile(String magicUsersConfigurationFile) {
        this.m_magicUsersConfigurationFile = magicUsersConfigurationFile;
    }

    public String getMagicUsersConfigurationFile() {
        return this.m_magicUsersConfigurationFile;
    }

    @Override
    public SpringSecurityUser getByUsername(String username) {
        this.reloadIfNecessary();
        OnmsUser user = this.m_magicUsers.containsKey(username) ? this.m_magicUsers.get(username) : this.m_users.get(username);
        if (user == null) {
            return null;
        }
        SpringSecurityUser springUser = new SpringSecurityUser(user);
        springUser.setAuthorities(this.getAuthoritiesByUsername(username));
        return springUser;
    }

    private void reloadIfNecessary() {
        if (this.isUsersParseNecessary()) {
            this.parseUsers();
        }
        if (this.isMagicUsersParseNecessary() || this.m_useGroups && this.isGroupsParseNecessary()) {
            this.parseMagicUsers();
        }
    }

    public long getMagicUsersLastModified() {
        return this.m_magicUsersLastModified;
    }

    public long getUsersLastModified() {
        return this.m_usersLastModified;
    }

    public long getGroupsLastModified() {
        return this.m_groupsLastModified;
    }

    public boolean isUseGroups() {
        return this.m_useGroups;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager mgr) {
        this.m_userManager = mgr;
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public void setGroupManager(GroupManager mgr) {
        this.m_groupManager = mgr;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_usersConfigurationFile != null ? 1 : 0) != 0, (String)"usersConfigurationFile parameter must be set to the location of the users.xml configuration file");
        Assert.state((!this.m_useGroups || this.m_groupsConfigurationFile != null ? 1 : 0) != 0, (String)"groupsConfigurationFile parameter must be set to the location of the groups.xml configuration file");
        Assert.state((this.m_magicUsersConfigurationFile != null ? 1 : 0) != 0, (String)"magicUsersConfigurationFile parameter must be set to the location of the magic-users.properties configuration file");
        Assert.notNull((Object)this.m_userManager);
        Assert.notNull((Object)this.m_groupManager);
    }
}

