/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.web.HttpClientWrapperConfigHelper;
import org.opennms.netmgt.rt.CustomField;
import org.opennms.netmgt.rt.CustomFieldValue;
import org.opennms.netmgt.rt.RTInaccessibleQueue;
import org.opennms.netmgt.rt.RTQueue;
import org.opennms.netmgt.rt.RTTicket;
import org.opennms.netmgt.rt.RTUser;
import org.opennms.netmgt.rt.RequestTrackerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(RequestTracker.class);
    private static final Pattern IN_TOKENS_PATTERN = Pattern.compile("^(\\w+):\\s*(.*?)\\s*$", 8);
    private static final Pattern TICKET_CREATED_PATTERN = Pattern.compile("(?s) Ticket (\\d+) created");
    private static final Pattern TICKET_UPDATED_PATTERN = Pattern.compile("(?s) Ticket (\\d+) updated");
    private static final Pattern OLD_CUSTOM_FIELD_PATTERN = Pattern.compile("^C(?:ustom)?F(?:ield)?-(.*?):\\s*(.*?)\\s*$");
    private static final Pattern NEW_CUSTOM_FIELD_PATTERN = Pattern.compile("^CF\\.\\{(.*?)\\}:\\s*(.*?)\\s*$");
    private final String m_baseURL;
    private String m_user;
    private String m_password;
    private int m_timeout;
    private int m_retries;
    private boolean m_useSystemProxy;
    private HttpClientWrapper m_clientWrapper;

    public RequestTracker(String baseURL, String username, String password, int timeout, int retries, boolean useSystemProxy) {
        this.m_baseURL = baseURL;
        this.m_user = username;
        this.m_password = password;
        this.m_timeout = timeout;
        this.m_retries = retries;
        this.m_useSystemProxy = useSystemProxy;
    }

    public Long createTicket(RTTicket ticket) throws RequestTrackerException {
        HttpPost post = new HttpPost(this.m_baseURL + "/REST/1.0/edit");
        return this.postEdit(post, ticket.toContent(), TICKET_CREATED_PATTERN);
    }

    public Long updateTicket(Long id, String content) throws RequestTrackerException {
        HttpPost post = new HttpPost(this.m_baseURL + "/REST/1.0/ticket/" + id + "/edit");
        return this.postEdit(post, content, TICKET_UPDATED_PATTERN);
    }

    public Long postEdit(HttpPost post, String content, Pattern pattern) throws RequestTrackerException {
        String rtTicketNumber = null;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("user", this.m_user));
        params.add(new BasicNameValuePair("pass", this.m_password));
        params.add(new BasicNameValuePair("content", content));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = this.getClientWrapper().execute((HttpUriRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            String in = EntityUtils.toString((HttpEntity)response.getEntity());
            Matcher matcher = pattern.matcher(in);
            if (matcher.find()) {
                rtTicketNumber = matcher.group(1);
            } else {
                LOG.debug("did not get ticket ID from response when posting to {}", (Object)post);
            }
        }
        catch (Exception e) {
            LOG.error("Failure attempting to update ticket.", (Throwable)e);
            throw new RequestTrackerException(e);
        }
        finally {
            this.getClientWrapper().close(response);
        }
        if (rtTicketNumber == null) {
            return null;
        }
        return Long.valueOf(rtTicketNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTUser getUserInfo(String username) {
        this.getSession();
        Map<Object, Object> attributes = Collections.emptyMap();
        HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/user/" + username);
        CloseableHttpResponse response = null;
        try {
            response = this.getClientWrapper().execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            if (response.getEntity() != null) {
                attributes = this.parseResponseStream(response.getEntity().getContent());
            }
        }
        catch (Exception e) {
            LOG.error("An exception occurred while getting user info for {}", (Object)username, (Object)e);
            RTUser rTUser = null;
            return rTUser;
        }
        finally {
            this.getClientWrapper().close(response);
        }
        String id = (String)attributes.get("id");
        String realname = (String)attributes.get("realname");
        String email = (String)attributes.get("emailaddress");
        if (id == null || "".equals(id)) {
            LOG.error("Unable to retrieve ID from user info.");
            return null;
        }
        return new RTUser(Long.parseLong(id.replace("user/", "")), username, realname, email);
    }

    public RTTicket getTicket(Long ticketId, boolean getTextAttachment) throws RequestTrackerException {
        this.getSession();
        Map<String, String> attributes = this.getTicketAttributes(ticketId.toString());
        RTTicket ticket = new RTTicket();
        if (attributes == null) {
            throw new RequestTrackerException("received no ticket attributes back from RT");
        }
        String id = attributes.remove("id").replace("ticket/", "");
        if (id != null && id.length() > 0) {
            ticket.setId(Long.valueOf(id));
        }
        ticket.setQueue(attributes.remove("queue"));
        ticket.setCreated(attributes.remove("created"));
        ticket.setSubject(attributes.remove("subject"));
        ticket.setText(attributes.remove("text"));
        ticket.setStatus(attributes.remove("status"));
        if (attributes.containsKey("requestors")) {
            for (String requestor : attributes.remove("requestors").split("\\s*,\\s*")) {
                ticket.addRequestor(requestor);
            }
        } else if (attributes.containsKey("requestor")) {
            ticket.setRequestor(attributes.remove("requestor"));
        }
        for (Map.Entry entry : attributes.entrySet()) {
            String bute = (String)entry.getKey();
            String headerForm = bute + ": " + (String)entry.getValue();
            Matcher cfMatcher = NEW_CUSTOM_FIELD_PATTERN.matcher(headerForm);
            if (!cfMatcher.matches()) continue;
            CustomField cf = new CustomField(cfMatcher.group(1));
            cf.addValue(new CustomFieldValue(cfMatcher.group(2)));
            attributes.remove(bute);
        }
        if (attributes.size() > 0) {
            LOG.trace("unhandled RT ticket attributes: {}", attributes.entrySet());
        }
        if ((ticket.getText() == null || ticket.getText().equals("") && getTextAttachment) && (attributes = this.getTicketAttributes(ticketId + "/attachments")).containsKey("attachments")) {
            Matcher matcher = IN_TOKENS_PATTERN.matcher(attributes.get("attachments"));
            matcher.find();
            String string = matcher.group(1);
            if (string != null && !"".equals(string) && (attributes = this.getTicketAttributes(ticketId + "/attachments/" + string)).containsKey("content")) {
                ticket.setText(attributes.remove("content"));
            }
            LOG.debug("attachment ID = {}", (Object)string);
        }
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RTTicket> getTicketsForQueue(String queueName, long limit) {
        ArrayList<Long> ticketIds;
        ArrayList<RTTicket> tickets;
        block22: {
            InputStreamReader isr;
            this.getSession();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("query", "Queue='" + queueName + "' AND Status='open'"));
            params.add(new BasicNameValuePair("format", "i"));
            params.add(new BasicNameValuePair("orderby", "-id"));
            HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/search/ticket?" + URLEncodedUtils.format(params, (Charset)StandardCharsets.UTF_8));
            tickets = new ArrayList<RTTicket>();
            ticketIds = new ArrayList<Long>();
            CloseableHttpResponse response = null;
            try {
                List<RTTicket> list;
                BufferedReader br;
                block21: {
                    response = this.getClientWrapper().execute((HttpUriRequest)get);
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode != 200) {
                        throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
                    }
                    isr = null;
                    br = null;
                    try {
                        if (response.getEntity() == null) {
                            List<RTTicket> list2 = null;
                            return list2;
                        }
                        isr = new InputStreamReader(response.getEntity().getContent());
                        br = new BufferedReader(isr);
                        String line = null;
                        do {
                            if ((line = br.readLine()) == null) continue;
                            if (line.contains("does not exist.")) {
                                list = null;
                                IOUtils.closeQuietly((Reader)br);
                                break block21;
                            }
                            if (!line.startsWith("ticket/")) continue;
                            ticketIds.add(Long.parseLong(line.replace("ticket/", "")));
                        } while (line != null);
                        IOUtils.closeQuietly((Reader)br);
                    }
                    catch (Exception e) {
                        throw new RequestTrackerException("Unable to read ticket IDs from query.", e);
                    }
                }
                IOUtils.closeQuietly((Reader)isr);
                return list;
                IOUtils.closeQuietly((Reader)isr);
                break block22;
                finally {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(isr);
                }
            }
            catch (Exception e) {
                LOG.error("An exception occurred while getting tickets for queue {}", (Object)queueName, (Object)e);
                isr = null;
                return isr;
            }
            finally {
                this.getClientWrapper().close(response);
            }
        }
        Iterator iterator = ticketIds.iterator();
        while (iterator.hasNext()) {
            Long id = (Long)iterator.next();
            try {
                tickets.add(this.getTicket(id, false));
            }
            catch (RequestTrackerException e) {
                LOG.warn("Unable to retrieve ticket.", (Throwable)e);
            }
        }
        return tickets;
    }

    public RTQueue getFirstPublicQueueForUser(String username) throws RequestTrackerException {
        if (username == null) {
            LOG.error("User name cannot be null.");
            throw new RequestTrackerException("User name cannot be null.");
        }
        for (RTQueue queue : this.getQueuesForUser(username)) {
            if (!queue.isAccessible() || queue.getName().startsWith("___")) continue;
            return queue;
        }
        return null;
    }

    public List<RTQueue> getQueuesForUser(String username) throws RequestTrackerException {
        if (username == null) {
            LOG.error("User name cannot be null.");
            throw new RequestTrackerException("User name cannot be null.");
        }
        this.getSession();
        ArrayList<RTQueue> queues = new ArrayList<RTQueue>();
        long id = 1L;
        RTQueue queue = null;
        while ((queue = this.getQueue(id)) != null) {
            if (queue.isAccessible() && queue.getName().startsWith("___")) {
                LOG.debug("found queue: {} (skipping)", (Object)queue);
            } else {
                LOG.debug("found queue: {}", (Object)queue);
                queues.add(queue);
            }
            ++id;
        }
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTQueue getQueue(long id) throws RequestTrackerException {
        this.getSession();
        Map<Object, Object> attributes = Collections.emptyMap();
        HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/queue/" + id);
        CloseableHttpResponse response = null;
        try {
            response = this.getClientWrapper().execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            if (response.getEntity() == null) {
                LOG.debug("no entity returned by HTTP client");
            }
            attributes = this.parseResponseStream(response.getEntity().getContent());
        }
        catch (Exception e) {
            LOG.error("An exception occurred while getting queue #{}", (Object)id, (Object)e);
            RTQueue rTQueue = null;
            return rTQueue;
        }
        finally {
            this.getClientWrapper().close(response);
        }
        if (attributes.containsKey("id") && attributes.containsKey("name")) {
            String queueId = ((String)attributes.get("id")).replace("queue/", "");
            long longId = Long.parseLong(queueId);
            String name = ((String)attributes.get("name")).trim();
            String priority = ((String)attributes.get("finalpriority")).trim();
            LOG.debug("name = {}, priority = {}", (Object)name, (Object)priority);
            if ("".equals(name) && "".equals(priority)) {
                LOG.debug("We got a response back, but it had no name or priority; assuming we have no access to this queue.");
                return new RTInaccessibleQueue(longId);
            }
            return new RTQueue(longId, (String)attributes.get("name"));
        }
        LOG.debug("id or name missing ({}, {})", attributes.get("id"), attributes.get("name"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getTicketAttributes(String ticketQuery) throws RequestTrackerException {
        if (ticketQuery == null) {
            LOG.error("No ticket query specified!");
            throw new RequestTrackerException("No ticket query specified!");
        }
        this.getSession();
        Map<String, String> ticketAttributes = Collections.emptyMap();
        HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/ticket/" + ticketQuery);
        CloseableHttpResponse response = null;
        try {
            response = this.getClientWrapper().execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            if (response.getEntity() == null) {
                LOG.debug("no entity returned by HTTP client");
            }
            ticketAttributes = this.parseResponseStream(response.getEntity().getContent());
        }
        catch (Exception e) {
            LOG.error("HTTP exception attempting to get ticket.", (Throwable)e);
        }
        finally {
            this.getClientWrapper().close(response);
        }
        if (ticketAttributes.size() == 0) {
            LOG.debug("matcher did not match {}", (Object)IN_TOKENS_PATTERN.pattern());
            return null;
        }
        return ticketAttributes;
    }

    protected Map<String, String> parseResponseStream(InputStream responseStream) throws IOException {
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        LOG.debug("parsing response");
        String lastIndent = "";
        String lastKey = null;
        for (String line : IOUtils.readLines((InputStream)responseStream)) {
            LOG.trace("line = {}", (Object)line);
            if (line.contains("does not exist.")) {
                return ticketAttributes;
            }
            if (lastIndent.length() > 0 && line.startsWith(lastIndent)) {
                String value = (String)ticketAttributes.get(lastKey) + "\n" + line.replaceFirst("^" + lastIndent, "");
                ticketAttributes.put(lastKey, value);
                continue;
            }
            Matcher inTokensMatcher = IN_TOKENS_PATTERN.matcher(line);
            Matcher cfMatcherOld = OLD_CUSTOM_FIELD_PATTERN.matcher(line);
            Matcher cfMatcherNew = NEW_CUSTOM_FIELD_PATTERN.matcher(line);
            if (!inTokensMatcher.matches()) continue;
            lastKey = cfMatcherOld.matches() ? "CF.{" + cfMatcherOld.group(1) + "}" : (cfMatcherNew.matches() ? "CF.{" + cfMatcherNew.group(1) + "}" : inTokensMatcher.group(1).toLowerCase());
            lastIndent = lastKey.replaceAll(".", " ") + "  ";
            ticketAttributes.put(lastKey, inTokensMatcher.group(2));
        }
        return ticketAttributes;
    }

    private void getSession() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HttpClientWrapper getClientWrapper() {
        if (this.m_clientWrapper == null) {
            this.m_clientWrapper = HttpClientWrapper.create().setSocketTimeout(Integer.valueOf(this.m_timeout)).setConnectionTimeout(Integer.valueOf(this.m_timeout)).setRetries(Integer.valueOf(this.m_retries)).useBrowserCompatibleCookies().dontReuseConnections();
            if (this.m_useSystemProxy) {
                this.m_clientWrapper.useSystemProxySettings();
            }
            HttpPost post = new HttpPost(this.m_baseURL + "/REST/1.0/user/" + this.m_user);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("user", this.m_user));
            params.add(new BasicNameValuePair("pass", this.m_password));
            CloseableHttpResponse response = null;
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
                post.setEntity((HttpEntity)entity);
                response = this.m_clientWrapper.execute((HttpUriRequest)post);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
                }
                if (response.getEntity() != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                LOG.warn("got user session for username: {}", (Object)this.m_user);
                this.m_clientWrapper.close(response);
            }
            catch (Exception e) {
                LOG.warn("Unable to get session (by requesting user details)", (Throwable)e);
            }
            finally {
                this.m_clientWrapper.close(response);
            }
        }
        return this.m_clientWrapper;
    }

    public String getUsername() {
        return this.m_user;
    }

    public void setUsername(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("base-url", (Object)this.m_baseURL).append("username", (Object)this.m_user).append("password", (Object)this.m_password.replaceAll(".", "*")).append("timeout", this.m_timeout).append("retries", this.m_retries).append(HttpClientWrapperConfigHelper.PARAMETER_KEYS.useSystemProxy.name(), this.m_useSystemProxy).toString();
    }
}

