/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rt;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.opennms.netmgt.rt.RtConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRtConfigDao
implements RtConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyRtConfigDao.class);
    private Configuration m_config = null;
    private long m_lastUpdated = 0L;
    private static final long TIMEOUT = 300000L;

    protected Configuration getProperties() {
        long now = System.currentTimeMillis();
        if (this.m_config == null || now > this.m_lastUpdated + 300000L) {
            String propsFile = this.getFile();
            LOG.debug("loading properties from: {}", (Object)propsFile);
            try {
                this.m_config = new PropertiesConfiguration(propsFile);
                this.m_lastUpdated = now;
            }
            catch (ConfigurationException e) {
                LOG.error("Unable to load RT properties", (Throwable)e);
            }
        }
        return this.m_config;
    }

    protected String getFile() {
        return System.getProperty("opennms.home") + File.separatorChar + "etc" + File.separatorChar + this.getPrefix() + ".properties";
    }

    protected String getPrefix() {
        return "rt";
    }

    @Override
    public String getUsername() {
        return this.getProperties().getString(this.getPrefix() + ".username");
    }

    @Override
    public String getPassword() {
        return this.getProperties().getString(this.getPrefix() + ".password");
    }

    @Override
    public String getQueue() {
        return this.getProperties().getString(this.getPrefix() + ".queue", "General");
    }

    @Override
    public List<String> getValidClosedStatus() {
        return this.getProperties().getList(this.getPrefix() + ".validclosedstatus");
    }

    @Override
    public List<String> getValidOpenStatus() {
        return this.getProperties().getList(this.getPrefix() + ".validopenstatus");
    }

    @Override
    public List<String> getValidCancelledStatus() {
        return this.getProperties().getList(this.getPrefix() + ".validcancelledstatus");
    }

    @Override
    public String getOpenStatus() {
        return this.getProperties().getString(this.getPrefix() + ".openstatus", "open");
    }

    @Override
    public String getClosedStatus() {
        return this.getProperties().getString(this.getPrefix() + ".closedstatus", "closed");
    }

    @Override
    public String getCancelledStatus() {
        return this.getProperties().getString(this.getPrefix() + ".cancelledstatus", "cancelled");
    }

    @Override
    public String getRequestor() {
        return this.getProperties().getString(this.getPrefix() + ".requestor");
    }

    @Override
    public String getBaseURL() {
        return this.getProperties().getString(this.getPrefix() + ".baseURL");
    }

    @Override
    public int getTimeout() {
        return this.getProperties().getInt(this.getPrefix() + ".timeout", 3000);
    }

    @Override
    public int getRetry() {
        return this.getProperties().getInt(this.getPrefix() + ".retry", 0);
    }

    @Override
    public boolean getUseSystemProxy() {
        return this.getProperties().getBoolean(this.getPrefix() + ".useSystemProxy", false);
    }

    @Override
    public void save() throws IOException {
        LOG.warn("ReadOnlyRtConfigDao cannot save.");
    }

    protected void clearCache() {
        this.m_config = null;
    }

    protected String getStringProperty(String propertyName, String defaultValue) {
        if (this.getProperties() != null) {
            return this.getProperties().getString(propertyName, defaultValue);
        }
        LOG.warn("getProperties() is null, returning the default value instead");
        return defaultValue;
    }

    protected void setProperty(String propertyName, Object propertyValue) {
        if (this.getProperties() == null) {
            LOG.warn("Unable to set the {} property, getProperties() is null!", (Object)propertyName);
            return;
        }
        this.getProperties().setProperty(propertyName, propertyValue);
    }
}

