/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.rt.CustomField;
import org.opennms.netmgt.rt.CustomFieldValue;
import org.opennms.netmgt.rt.RTInaccessibleQueue;
import org.opennms.netmgt.rt.RTQueue;
import org.opennms.netmgt.rt.RTTicket;
import org.opennms.netmgt.rt.RTUser;
import org.opennms.netmgt.rt.RequestTrackerException;

public class RequestTracker {
    private final String m_baseURL;
    private String m_user;
    private String m_password;
    private int m_timeout;
    private int m_retries;
    private Pattern m_inTokensPattern = Pattern.compile("^(\\w+):\\s*(.*?)\\s*$", 8);
    private Pattern m_ticketCreatedPattern = Pattern.compile("(?s) Ticket (\\d+) created");
    private Pattern m_ticketUpdatedPattern = Pattern.compile("(?s) Ticket (\\d+) updated");
    private Pattern m_customFieldPatternOld = Pattern.compile("^C(?:ustom)?F(?:ield)?-(.*?):\\s*(.*?)\\s*$");
    private Pattern m_customFieldPatternNew = Pattern.compile("^CF\\.\\{(.*?)\\}:\\s*(.*?)\\s*$");
    private DefaultHttpClient m_client;

    public RequestTracker(String baseURL, String username, String password, int timeout, int retries) {
        this.m_baseURL = baseURL;
        this.m_user = username;
        this.m_password = password;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    public Long createTicket(RTTicket ticket) throws RequestTrackerException {
        HttpPost post = new HttpPost(this.m_baseURL + "/REST/1.0/edit");
        return this.postEdit(post, ticket.toContent(), this.m_ticketCreatedPattern);
    }

    public Long updateTicket(Long id, String content) throws RequestTrackerException {
        HttpPost post = new HttpPost(this.m_baseURL + "/REST/1.0/ticket/" + id + "/edit");
        return this.postEdit(post, content, this.m_ticketUpdatedPattern);
    }

    public Long postEdit(HttpPost post, String content, Pattern pattern) throws RequestTrackerException {
        String rtTicketNumber = null;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("user", this.m_user));
        params.add(new BasicNameValuePair("pass", this.m_password));
        params.add(new BasicNameValuePair("content", content));
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unsupported encoding exception for UTF-8 -- WTF?!", (Object[])new Object[0]);
        }
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            String in = EntityUtils.toString((HttpEntity)response.getEntity());
            Matcher matcher = pattern.matcher(in);
            if (matcher.find()) {
                rtTicketNumber = matcher.group(1);
            } else {
                LogUtils.debugf((Object)this, (String)"did not get ticket ID from response when posting to %s", (Object[])new Object[]{post.toString()});
            }
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Failure attempting to update ticket.", (Object[])new Object[0]);
            throw new RequestTrackerException(e);
        }
        if (rtTicketNumber == null) {
            return null;
        }
        return Long.valueOf(rtTicketNumber);
    }

    public RTUser getUserInfo(String username) {
        this.getSession();
        Map<Object, Object> attributes = Collections.emptyMap();
        HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/user/" + username);
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            if (response.getEntity() != null) {
                attributes = this.parseResponseStream(response.getEntity().getContent());
            }
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)("An exception occurred while getting user info for " + username), (Object[])new Object[0]);
            return null;
        }
        String id = (String)attributes.get("id");
        String realname = (String)attributes.get("realname");
        String email = (String)attributes.get("emailaddress");
        if (id == null || "".equals(id)) {
            LogUtils.errorf((Object)this, (String)"Unable to retrieve ID from user info.", (Object[])new Object[0]);
            return null;
        }
        return new RTUser(Long.parseLong(id.replace("user/", "")), username, realname, email);
    }

    public RTTicket getTicket(Long ticketId, boolean getTextAttachment) throws RequestTrackerException {
        this.getSession();
        Map<String, String> attributes = this.getTicketAttributes(ticketId.toString());
        RTTicket ticket = new RTTicket();
        if (attributes == null) {
            throw new RequestTrackerException("received no ticket attributes back from RT");
        }
        String id = attributes.remove("id").replace("ticket/", "");
        if (id != null && id.length() > 0) {
            ticket.setId(Long.valueOf(id));
        }
        ticket.setQueue(attributes.remove("queue"));
        ticket.setCreated(attributes.remove("created"));
        ticket.setSubject(attributes.remove("subject"));
        ticket.setText(attributes.remove("text"));
        ticket.setStatus(attributes.remove("status"));
        if (attributes.containsKey("requestors")) {
            for (String requestor : attributes.remove("requestors").split("\\s*,\\s*")) {
                ticket.addRequestor(requestor);
            }
        } else if (attributes.containsKey("requestor")) {
            ticket.setRequestor(attributes.remove("requestor"));
        }
        for (String bute : attributes.keySet()) {
            String headerForm = bute + ": " + attributes.get(bute);
            Matcher cfMatcher = this.m_customFieldPatternNew.matcher(headerForm);
            if (!cfMatcher.matches()) continue;
            CustomField cf = new CustomField(cfMatcher.group(1));
            cf.addValue(new CustomFieldValue(cfMatcher.group(2)));
            attributes.remove(bute);
        }
        if (LogUtils.isTraceEnabled((Object)this) && attributes.size() > 0) {
            LogUtils.tracef((Object)this, (String)"unhandled RT ticket attributes: %s", (Object[])new Object[]{attributes.keySet().toString()});
        }
        if ((ticket.getText() == null || ticket.getText().equals("") && getTextAttachment) && (attributes = this.getTicketAttributes(ticketId + "/attachments")).containsKey("attachments")) {
            Matcher matcher = this.m_inTokensPattern.matcher(attributes.get("attachments"));
            matcher.find();
            String attachmentId = matcher.group(1);
            if (attachmentId != null && !"".equals(attachmentId) && (attributes = this.getTicketAttributes(ticketId + "/attachments/" + attachmentId)).containsKey("content")) {
                ticket.setText(attributes.remove("content"));
            }
            LogUtils.debugf((Object)this, (String)"attachment ID = %s", (Object[])new Object[]{attachmentId});
        }
        return ticket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RTTicket> getTicketsForQueue(String queueName, long limit) {
        ArrayList<Long> ticketIds;
        ArrayList<RTTicket> tickets;
        block17: {
            this.getSession();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("query", "Queue='" + queueName + "' AND Status='open'"));
            params.add(new BasicNameValuePair("format", "i"));
            params.add(new BasicNameValuePair("orderby", "-id"));
            HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/search/ticket?" + URLEncodedUtils.format(params, (String)"UTF-8"));
            tickets = new ArrayList<RTTicket>();
            ticketIds = new ArrayList<Long>();
            try {
                List<RTTicket> list;
                BufferedReader br;
                InputStreamReader isr;
                block16: {
                    HttpResponse response = this.getClient().execute((HttpUriRequest)get);
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode != 200) {
                        throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
                    }
                    isr = null;
                    br = null;
                    try {
                        if (response.getEntity() == null) {
                            List<RTTicket> list2 = null;
                            return list2;
                        }
                        isr = new InputStreamReader(response.getEntity().getContent());
                        br = new BufferedReader(isr);
                        String line = null;
                        do {
                            if ((line = br.readLine()) == null) continue;
                            if (line.contains("does not exist.")) {
                                list = null;
                                IOUtils.closeQuietly((Reader)br);
                                break block16;
                            }
                            if (!line.startsWith("ticket/")) continue;
                            ticketIds.add(Long.parseLong(line.replace("ticket/", "")));
                        } while (line != null);
                        IOUtils.closeQuietly((Reader)br);
                    }
                    catch (Exception e) {
                        throw new RequestTrackerException("Unable to read ticket IDs from query.", e);
                    }
                }
                IOUtils.closeQuietly((Reader)isr);
                return list;
                IOUtils.closeQuietly((Reader)isr);
                break block17;
                finally {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(isr);
                }
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)("An exception occurred while getting tickets for queue " + queueName), (Object[])new Object[0]);
                return null;
            }
        }
        Iterator i$ = ticketIds.iterator();
        while (i$.hasNext()) {
            Long id = (Long)i$.next();
            try {
                tickets.add(this.getTicket(id, false));
            }
            catch (RequestTrackerException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to retrieve ticket.", (Object[])new Object[0]);
            }
        }
        return tickets;
    }

    public RTQueue getFirstPublicQueueForUser(String username) throws RequestTrackerException {
        if (username == null) {
            LogUtils.errorf((Object)this, (String)"User name cannot be null.", (Object[])new Object[0]);
            throw new RequestTrackerException("User name cannot be null.");
        }
        for (RTQueue queue : this.getQueuesForUser(username)) {
            if (!queue.isAccessible() || queue.getName().startsWith("___")) continue;
            return queue;
        }
        return null;
    }

    public List<RTQueue> getQueuesForUser(String username) throws RequestTrackerException {
        if (username == null) {
            LogUtils.errorf((Object)this, (String)"User name cannot be null.", (Object[])new Object[0]);
            throw new RequestTrackerException("User name cannot be null.");
        }
        this.getSession();
        ArrayList<RTQueue> queues = new ArrayList<RTQueue>();
        long id = 1L;
        RTQueue queue = null;
        while ((queue = this.getQueue(id)) != null) {
            if (queue.isAccessible() && queue.getName().startsWith("___")) {
                LogUtils.debugf((Object)this, (String)"found queue: %s (skipping)", (Object[])new Object[]{queue});
            } else {
                LogUtils.debugf((Object)this, (String)"found queue: %s", (Object[])new Object[]{queue});
                queues.add(queue);
            }
            ++id;
        }
        return queues;
    }

    public RTQueue getQueue(long id) throws RequestTrackerException {
        this.getSession();
        Map<Object, Object> attributes = Collections.emptyMap();
        HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/queue/" + id);
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            if (response.getEntity() == null) {
                LogUtils.debugf((Object)this, (String)"no entity returned by HTTP client", (Object[])new Object[0]);
            }
            attributes = this.parseResponseStream(response.getEntity().getContent());
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)("An exception occurred while getting queue #" + id), (Object[])new Object[0]);
            return null;
        }
        if (attributes.containsKey("id") && attributes.containsKey("name")) {
            String queueId = ((String)attributes.get("id")).replace("queue/", "");
            long longId = Long.parseLong(queueId);
            String name = ((String)attributes.get("name")).trim();
            String priority = ((String)attributes.get("finalpriority")).trim();
            LogUtils.debugf((Object)this, (String)"name = %s, priority = %s", (Object[])new Object[]{name, priority});
            if ("".equals(name) && "".equals(priority)) {
                LogUtils.debugf((Object)this, (String)"We got a response back, but it had no name or priority; assuming we have no access to this queue.", (Object[])new Object[0]);
                return new RTInaccessibleQueue(longId);
            }
            return new RTQueue(longId, (String)attributes.get("name"));
        }
        LogUtils.debugf((Object)this, (String)"id or name missing (%d, %s)", (Object[])new Object[]{attributes.get("id"), attributes.get("name")});
        return null;
    }

    private Map<String, String> getTicketAttributes(String ticketQuery) throws RequestTrackerException {
        if (ticketQuery == null) {
            LogUtils.errorf((Object)this, (String)"No ticket query specified!", (Object[])new Object[0]);
            throw new RequestTrackerException("No ticket query specified!");
        }
        this.getSession();
        Map<String, String> ticketAttributes = Collections.emptyMap();
        HttpGet get = new HttpGet(this.m_baseURL + "/REST/1.0/ticket/" + ticketQuery);
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
            }
            if (response.getEntity() == null) {
                LogUtils.debugf((Object)this, (String)"no entity returned by HTTP client", (Object[])new Object[0]);
            }
            ticketAttributes = this.parseResponseStream(response.getEntity().getContent());
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"HTTP exception attempting to get ticket.", (Object[])new Object[0]);
        }
        if (ticketAttributes.size() == 0) {
            LogUtils.debugf((Object)this, (String)"matcher did not match %s", (Object[])new Object[]{this.m_inTokensPattern.pattern()});
            return null;
        }
        return ticketAttributes;
    }

    protected Map<String, String> parseResponseStream(InputStream responseStream) throws IOException {
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        LogUtils.debugf((Object)this, (String)"parsing response", (Object[])new Object[0]);
        String lastIndent = "";
        String lastKey = null;
        for (String line : IOUtils.readLines((InputStream)responseStream)) {
            LogUtils.tracef((Object)this, (String)"line = %s", (Object[])new Object[]{line});
            if (line.contains("does not exist.")) {
                return ticketAttributes;
            }
            if (lastIndent.length() > 0 && line.startsWith(lastIndent)) {
                String value = (String)ticketAttributes.get(lastKey) + "\n" + line.replaceFirst("^" + lastIndent, "");
                ticketAttributes.put(lastKey, value);
                continue;
            }
            Matcher inTokensMatcher = this.m_inTokensPattern.matcher(line);
            Matcher cfMatcherOld = this.m_customFieldPatternOld.matcher(line);
            Matcher cfMatcherNew = this.m_customFieldPatternNew.matcher(line);
            if (!inTokensMatcher.matches()) continue;
            lastKey = cfMatcherOld.matches() ? "CF.{" + cfMatcherOld.group(1) + "}" : (cfMatcherNew.matches() ? "CF.{" + cfMatcherNew.group(1) + "}" : inTokensMatcher.group(1).toLowerCase());
            lastIndent = lastKey.replaceAll(".", " ") + "  ";
            ticketAttributes.put(lastKey, inTokensMatcher.group(2));
        }
        return ticketAttributes;
    }

    private void getSession() {
        if (this.m_client == null) {
            HttpPost post = new HttpPost(this.m_baseURL + "/REST/1.0/user/" + this.m_user);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("user", this.m_user));
            params.add(new BasicNameValuePair("pass", this.m_password));
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"unsupported encoding exception for UTF-8 -- WTF?!", (Object[])new Object[0]);
            }
            try {
                HttpResponse response = this.getClient().execute((HttpUriRequest)post);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    throw new RequestTrackerException("Received a non-200 response code from the server: " + responseCode);
                }
                if (response.getEntity() != null) {
                    response.getEntity().consumeContent();
                }
                LogUtils.warnf((Object)this, (String)"got user session for username: %s", (Object[])new Object[]{this.m_user});
            }
            catch (Exception e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to get session (by requesting user details)", (Object[])new Object[0]);
            }
        }
    }

    public synchronized HttpClient getClient() {
        if (this.m_client == null) {
            this.m_client = new DefaultHttpClient();
            HttpParams clientParams = this.m_client.getParams();
            clientParams.setIntParameter("http.connection.timeout", this.m_timeout);
            clientParams.setIntParameter("http.socket.timeout", this.m_timeout);
            clientParams.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            this.m_client.setParams(clientParams);
            this.m_client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.m_retries, false));
        }
        return this.m_client;
    }

    public synchronized void setClient(DefaultHttpClient client) {
        this.m_client = client;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("base-url", (Object)this.m_baseURL).append("username", (Object)this.m_user).append("password", (Object)this.m_password.replaceAll(".", "*")).append("timeout", this.m_timeout).append("retries", this.m_retries).toString();
    }

    public String getUsername() {
        return this.m_user;
    }
}

