/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.rt.CustomField;

public class RTTicket
implements Serializable {
    private static final long serialVersionUID = 445141747501076112L;
    private static Pattern m_trim = Pattern.compile("\\s*\\n*$");
    private Long m_id;
    private String m_status;
    private String m_queue;
    private String m_created;
    private List<String> m_requestors = new ArrayList<String>();
    private String m_subject;
    private String m_text;
    private List<CustomField> m_customFields;

    public RTTicket() {
        this.m_customFields = new ArrayList<CustomField>();
    }

    public RTTicket(String queue, String requestor, String subject, String text, List<CustomField> customFields) {
        this(null, queue, requestor, subject, text, customFields);
    }

    public RTTicket(Long id, String queue, String requestor, String subject, String text, List<CustomField> customFields) {
        this.m_id = id;
        this.m_queue = queue;
        this.m_requestors.add(requestor);
        this.m_subject = subject;
        this.m_text = text;
        this.m_customFields = customFields;
    }

    public Long getId() {
        return this.m_id;
    }

    public void setId(Long id) {
        this.m_id = id;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public String getQueue() {
        return this.m_queue;
    }

    public void setQueue(String queue) {
        this.m_queue = queue;
    }

    public String getCreated() {
        return this.m_created;
    }

    public void setCreated(String created) {
        this.m_created = created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestor() {
        List<String> list = this.m_requestors;
        synchronized (list) {
            if (this.m_requestors.size() > 0) {
                return this.m_requestors.get(0);
            }
        }
        return null;
    }

    public List<String> getRequestors() {
        return this.m_requestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestors(List<String> requestors) {
        List<String> list = this.m_requestors;
        synchronized (list) {
            this.m_requestors.clear();
            this.m_requestors.addAll(requestors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestor(String requestor) {
        List<String> list = this.m_requestors;
        synchronized (list) {
            this.m_requestors.clear();
            this.m_requestors.add(requestor);
        }
    }

    public void addRequestor(String requestor) {
        this.m_requestors.add(requestor);
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public List<CustomField> getCustomFields() {
        return this.m_customFields;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.m_customFields = customFields;
    }

    public void addCustomField(CustomField customField) {
        this.m_customFields.add(customField);
    }

    public String toString() {
        StringBuilder customFields = new StringBuilder();
        for (CustomField cf : this.m_customFields) {
            customFields.append(cf.toString()).append("\n");
        }
        return new ToStringBuilder((Object)this).append("ID", (Object)this.m_id).append("Queue", (Object)this.m_queue).append("Created", (Object)this.m_created).append("Requestors", (Object)StringUtils.join(this.m_requestors, (String)", ")).append("Status", (Object)this.m_status).append("Subject", (Object)this.m_subject).append("Text", (Object)this.m_text).append("Custom Fields", (Object)customFields.toString()).toString();
    }

    public String toContent() {
        StringBuilder contentBuilder = new StringBuilder();
        if (this.m_id == null) {
            contentBuilder.append("id: ticket/new\n");
            if (this.m_queue != null) {
                contentBuilder.append("Queue: ").append(this.m_queue).append("\n");
            }
            if (this.m_requestors != null) {
                contentBuilder.append("Requestor: ").append(this.getRequestor()).append("\n");
            }
            if (this.m_subject != null) {
                contentBuilder.append("Subject: ").append(this.m_subject.replaceAll("[\\r\\n]+", " ")).append("\n");
            }
            if (this.m_text != null) {
                contentBuilder.append("text: ").append(this.m_text.replaceAll("\\r?\\n", "\n ")).append("\n");
            }
            if (this.m_customFields.size() > 0) {
                for (CustomField field : this.m_customFields) {
                    if (field.getValues().size() == 0) continue;
                    if (field.getValues().size() > 1) {
                        LogUtils.warnf((Object)this, (String)"Field %s has %d values, using only the first one", (Object[])new Object[]{field.getName(), field.getValues().size()});
                    }
                    String value = field.getValues().get(0).getValue();
                    contentBuilder.append("CF.{").append(field.getName()).append("}: ").append(value).append("\n");
                }
            }
        }
        if (this.m_status != null) {
            contentBuilder.append("Status: ").append(this.m_status).append("\n");
        }
        return m_trim.matcher(contentBuilder.toString()).replaceAll("");
    }

    public RTTicket copy() {
        RTTicket newTicket = new RTTicket();
        newTicket.setId(this.m_id);
        newTicket.setQueue(this.m_queue);
        newTicket.setRequestors(this.m_requestors);
        newTicket.setStatus(this.m_status);
        newTicket.setSubject(this.m_subject);
        newTicket.setText(this.m_text);
        newTicket.setCustomFields(this.m_customFields);
        return newTicket;
    }
}

