/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.poller.remote.support.GeodataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataUtils.class);

    public static ImageComponent getImageFromURL(URL url) {
        try {
            return new ImageComponent(ImageIO.read(url));
        }
        catch (Exception e) {
            LOG.warn("Unable to ready image: {}", (Object)url, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> fetchGeodata() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String url = "http://freegeoip.net/xml/";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet get = new HttpGet("http://freegeoip.net/xml/");
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String xml = EntityUtils.toString((HttpEntity)entity);
            System.err.println("xml = " + xml);
            GeodataResponse geoResponse = (GeodataResponse)JaxbUtils.unmarshal(GeodataResponse.class, (String)xml);
            ret.put("external-ip-address", InetAddressUtils.str((InetAddress)geoResponse.getIp()));
            ret.put("country-code", geoResponse.getCountryCode());
            ret.put("region-code", geoResponse.getRegionCode());
            ret.put("city", geoResponse.getCity());
            ret.put("zip-code", geoResponse.getZipCode());
            ret.put("time-zone", geoResponse.getTimeZone());
            ret.put("latitude", geoResponse.getLatitude() == null ? null : geoResponse.getLatitude().toString());
            ret.put("longitude", geoResponse.getLongitude() == null ? null : geoResponse.getLongitude().toString());
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        catch (Exception e) {
            LOG.debug("Failed to get GeoIP data from http://freegeoip.net/xml/", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
        return ret;
    }

    public static class ImageComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image m_image;

        public ImageComponent(Image image) {
            this.m_image = image;
            Dimension size = new Dimension(image.getWidth(null), image.getHeight(null));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.m_image, 0, 0, null);
        }
    }
}

