/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.poller.remote.AuthenticationBean;
import org.opennms.poller.remote.GroovyGui;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class Main
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    protected final String[] m_args;
    protected URI m_uri = null;
    protected String m_locationName;
    protected String m_username = null;
    protected String m_password = null;
    protected static boolean m_shuttingDown = false;
    protected boolean m_gui = false;

    private Main(String[] args) {
        this.m_args = Arrays.copyOf(args, args.length);
        String pingerClass = System.getProperty("org.opennms.netmgt.icmp.pingerClass");
        if (pingerClass == null) {
            LOG.info("System property org.opennms.netmgt.icmp.pingerClass is not set; using JnaPinger by default");
            System.setProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jna.JnaPinger");
        }
        LOG.info("Pinger class: {}", (Object)System.getProperty("org.opennms.netmgt.icmp.pingerClass"));
    }

    private void getAuthenticationInfo() {
        if (this.m_uri == null || this.m_uri.getScheme() == null) {
            throw new RuntimeException("no URI specified!");
        }
        if (this.m_uri.getScheme().equals("rmi")) {
            return;
        }
        if (this.m_username == null) {
            GroovyGui gui = Main.createGui();
            gui.createAndShowGui();
            AuthenticationBean auth = gui.getAuthenticationBean();
            this.m_username = auth.getUsername();
            this.m_password = auth.getPassword();
        }
        if (this.m_username != null) {
            SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)this.m_username, (Object)this.m_password));
        }
    }

    private static GroovyGui createGui() {
        try {
            return (GroovyGui)Class.forName("org.opennms.groovy.poller.remote.ConfigurationGui").newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to find Configuration GUI!", e);
        }
    }

    @Override
    public void run() {
        try {
            this.parseArguments(this.m_args);
            this.getAuthenticationInfo();
            AbstractApplicationContext context = this.createAppContext();
            PollerFrontEnd frontEnd = Main.getPollerFrontEnd(context);
            if (!this.m_gui && !frontEnd.isRegistered()) {
                if (this.m_locationName == null) {
                    LOG.error("No location name provided.  You must pass a location name the first time you start the remote poller!");
                    System.exit(27);
                } else {
                    frontEnd.register(this.m_locationName);
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Exception occurred during registration!", e);
            System.exit(27);
        }
    }

    private void parseArguments(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("h", "help", false, "this help");
        options.addOption("d", "debug", false, "write debug messages to the log");
        options.addOption("g", "gui", false, "start a GUI (default: false)");
        options.addOption("l", "location", true, "the location name of this remote poller");
        options.addOption("u", "url", true, "the URL for OpenNMS (example: https://server-name/opennms-remoting)");
        options.addOption("n", "name", true, "the name of the user to connect as");
        options.addOption("p", "password", true, "the password to use when connecting");
        PosixParser parser = new PosixParser();
        CommandLine cl = parser.parse(options, args);
        if (cl.hasOption("h")) {
            Main.usage(options);
            System.exit(1);
        }
        if (cl.hasOption("d")) {
            // empty if block
        }
        if (cl.hasOption("l")) {
            this.m_locationName = cl.getOptionValue("l");
        }
        if (cl.hasOption("u")) {
            String arg = cl.getOptionValue("u").toLowerCase();
            try {
                this.m_uri = new URI(arg);
            }
            catch (URISyntaxException e) {
                Main.usage(options);
                e.printStackTrace();
                System.exit(2);
            }
        } else {
            Main.usage(options);
            System.exit(3);
        }
        if (cl.hasOption("g")) {
            this.m_gui = true;
        }
        if (cl.hasOption("n")) {
            this.m_username = cl.getOptionValue("n");
            this.m_password = cl.getOptionValue("p");
            if (this.m_password == null) {
                this.m_password = "";
            }
        }
    }

    private static void usage(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Main.class.getName() + " -u [URL] [options]", o);
    }

    private AbstractApplicationContext createAppContext() {
        File homeDir = new File(System.getProperty("user.home"));
        String homeUrl = homeDir.toURI().toString();
        if (homeUrl.endsWith("/")) {
            homeUrl = homeUrl.substring(0, homeUrl.length() - 1);
        }
        LOG.info("user.home.url = {}", (Object)homeUrl);
        System.setProperty("user.home.url", homeUrl);
        String serverURI = this.m_uri.toString().replaceAll("/*$", "");
        LOG.info("opennms.poller.server.url = {}", (Object)serverURI);
        System.setProperty("opennms.poller.server.url", serverURI);
        LOG.info("location name = {}", (Object)this.m_locationName);
        ArrayList<String> configs = new ArrayList<String>();
        configs.add("classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd-" + this.m_uri.getScheme() + ".xml");
        configs.add("classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml");
        if (this.m_gui) {
            configs.add("classpath:/META-INF/opennms/applicationContext-ws-gui.xml");
        }
        final ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configs.toArray(new String[0]));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                m_shuttingDown = true;
                context.close();
            }
        });
        return context;
    }

    private static PollerFrontEnd getPollerFrontEnd(AbstractApplicationContext context) {
        PollerFrontEnd frontEnd = (PollerFrontEnd)context.getBean("pollerFrontEnd");
        frontEnd.addPropertyChangeListener(new PropertyChangeListener(){

            private boolean shouldExit(PropertyChangeEvent e) {
                LOG.info("shouldExit: received property change event for property: {}; oldvalue: {}; newvalue: {}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
                String propName = e.getPropertyName();
                Object newValue = e.getNewValue();
                if ("exitNecessary".equals(propName) && Boolean.TRUE.equals(newValue)) {
                    LOG.info("shouldExit: Exiting because exitNecessary is TRUE");
                    return true;
                }
                if ("started".equals(propName) && Boolean.FALSE.equals(newValue)) {
                    LOG.info("shouldExit: Exiting because started is now false");
                    return true;
                }
                LOG.info("shouldExit: not exiting");
                return false;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!m_shuttingDown && this.shouldExit(e)) {
                    System.exit(10);
                }
            }
        });
        return frontEnd;
    }

    public static void main(String[] args) {
        try {
            String killSwitchFileName = System.getProperty("opennms.poller.killSwitch.resource");
            File killSwitch = null;
            if (!"".equals(killSwitchFileName) && killSwitchFileName != null && !(killSwitch = new File(System.getProperty("opennms.poller.killSwitch.resource"))).exists()) {
                try {
                    killSwitch.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            new Main(args).run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

