/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.support.ScanReportPollerFrontEnd;
import org.opennms.poller.remote.ScanReportHandler;

public class FrontEndInvoker
extends SwingWorker<ScanReport, Integer>
implements PropertyChangeListener {
    private final CountDownLatch m_latch = new CountDownLatch(1);
    private final PollerFrontEnd m_frontEnd;
    private final ScanReportHandler m_handler;
    private final String m_locationName;
    private ScanReport m_scanReport;

    public FrontEndInvoker(PollerFrontEnd pfe, ScanReportHandler handler, String locationName) {
        this.m_frontEnd = pfe;
        this.m_handler = handler;
        this.m_locationName = locationName;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ScanReportPollerFrontEnd.ScanReportProperties.percentageComplete.toString())) {
            int percentComplete = Long.valueOf(Math.round((Double)evt.getNewValue() * 100.0)).intValue();
            this.setProgress(percentComplete);
        } else if (evt.getPropertyName().equals(PollerFrontEnd.PollerFrontEndStates.exitNecessary.toString())) {
            ScanReport report = (ScanReport)evt.getNewValue();
            System.out.println("Finished scan: " + report);
            this.m_scanReport = report;
            this.m_latch.countDown();
        } else {
            System.err.println("Unhandled property change event: " + evt.getPropertyName());
        }
    }

    @Override
    protected ScanReport doInBackground() throws Exception {
        this.m_frontEnd.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_frontEnd.initialize();
        this.m_frontEnd.register(this.m_locationName);
        this.m_latch.await();
        return this.m_scanReport;
    }

    @Override
    protected void done() {
        this.m_frontEnd.removePropertyChangeListener((PropertyChangeListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrontEndInvoker.this.m_handler.scanComplete(FrontEndInvoker.this.m_scanReport);
            }
        });
    }
}

