/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.opennms.poller.remote.MacKeybindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSLookAndFeel
extends MetalLookAndFeel {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSLookAndFeel.class);
    private static final long serialVersionUID = 1L;

    @Override
    public UIDefaults getDefaults() {
        UIDefaults def = super.getDefaults();
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            this.installKeybindingsIfPossible("sun.swing.plaf.WindowsKeybindings", def);
        } else if (osName.contains("Mac OS")) {
            MacKeybindings.installKeybindings(def);
        } else {
            this.installKeybindingsIfPossible("sun.swing.plaf.GTKKeybindings", def);
        }
        return def;
    }

    private void installKeybindingsIfPossible(String className, UIDefaults defaults) {
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getMethod("installKeybindings", UIDefaults.class);
            m.invoke(null, defaults);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warn("Unable to get {}, falling back to default Nimbus behavior.", (Object)className, (Object)e);
        }
    }
}

