/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.StrategyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBasedStrategyResolver
implements StrategyResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(ServiceBasedStrategyResolver.class);
    Map<String, SnmpStrategy> m_strategies = new ConcurrentHashMap<String, SnmpStrategy>();

    public static ServiceBasedStrategyResolver register() {
        ServiceBasedStrategyResolver resolver = new ServiceBasedStrategyResolver();
        SnmpUtils.setStrategyResolver(resolver);
        return resolver;
    }

    public static void unregister() {
        SnmpUtils.unsetStrategyResolver();
    }

    public void onBind(SnmpStrategy strategy, Map<String, String> props) {
        String key = props.get("implementation");
        if (key == null) {
            LOG.error("SnmpStrategy class published as service with out 'implementation' key.  Ignoring.");
            return;
        }
        this.m_strategies.put(key, strategy);
    }

    public void onUnbind(SnmpStrategy operation, Map<String, String> props) {
        String key = props.get("implementation");
        if (key != null) {
            this.m_strategies.remove(key);
        }
    }

    @Override
    public SnmpStrategy getStrategy() {
        String strategyClass = SnmpUtils.getStrategyClassName();
        SnmpStrategy strategy = this.m_strategies.get(strategyClass);
        if (strategy == null) {
            if (this.m_strategies.isEmpty()) {
                throw new RuntimeException("There is no SnmpStrategy registered.  Unable to find strategy " + strategyClass);
            }
            Map.Entry<String, SnmpStrategy> entry = this.m_strategies.entrySet().iterator().next();
            LOG.error("SnmpStrategy {} was not found! Using strategy {} instead!", (Object)strategyClass, (Object)entry.getKey());
            strategy = entry.getValue();
        }
        return strategy;
    }
}

