/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.PDUFactory;

public class DefaultPDUFactory
implements PDUFactory {
    public static final int GETBULK_DEFAULT_MAX_REPETITIONS = 5;
    public static final int GETBULK_DEFAULT_NON_REPEATERS = 0;
    private int pduType = -96;
    private int maxRepetitions = 5;
    private int nonRepeaters = 0;
    private OctetString contextEngineID;
    private OctetString contextName;

    public DefaultPDUFactory() {
    }

    public DefaultPDUFactory(int pduType) {
        this.setPduType(pduType);
    }

    public DefaultPDUFactory(int pduType, OctetString contextEngineID, OctetString contextName) {
        this(pduType);
        this.contextEngineID = contextEngineID;
        this.contextName = contextName;
    }

    public void setPduType(int pduType) {
        this.pduType = pduType;
    }

    public int getPduType() {
        return this.pduType;
    }

    @Override
    public PDU createPDU(Target target) {
        return DefaultPDUFactory.createPDU(target, this.pduType);
    }

    public static PDU createPDU(Target target, int pduType) {
        return DefaultPDUFactory.createPDU(target, pduType, 5, 0);
    }

    public static PDU createPDU(Target target, int pduType, int maxRepetitions, int nonRepeaters) {
        PDU request = DefaultPDUFactory.createPDU(target.getVersion());
        request.setType(pduType);
        if (pduType == -91) {
            request.setMaxRepetitions(maxRepetitions);
            request.setNonRepeaters(nonRepeaters);
        }
        return request;
    }

    public static PDU createPDU(int targetVersion) {
        PDU request;
        switch (targetVersion) {
            case 3: {
                request = new ScopedPDU();
                break;
            }
            case 0: {
                request = new PDUv1();
                break;
            }
            default: {
                request = new PDU();
            }
        }
        return request;
    }

    @Override
    public PDU createPDU(MessageProcessingModel messageProcessingModel) {
        return DefaultPDUFactory.createPduByMP(messageProcessingModel);
    }

    public static PDU createPDU(MessageProcessingModel messageProcessingModel, int pduType) {
        PDU pdu = DefaultPDUFactory.createPduByMP(messageProcessingModel);
        pdu.setType(pduType);
        return pdu;
    }

    private static PDU createPduByMP(MessageProcessingModel messageProcessingModel) {
        PDU pdu;
        switch (messageProcessingModel.getID()) {
            case 3: {
                pdu = new ScopedPDU();
                break;
            }
            case 0: {
                pdu = new PDUv1();
                break;
            }
            default: {
                pdu = new PDU();
            }
        }
        return pdu;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public void setContextEngineID(OctetString contextEngineID) {
        this.contextEngineID = contextEngineID;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    public void setContextName(OctetString contextName) {
        this.contextName = contextName;
    }
}

