/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;
import org.springframework.orm.hibernate3.HibernateCallback;

public class AlarmDaoHibernate
extends AbstractDaoHibernate<OnmsAlarm, Integer>
implements AlarmDao {
    public AlarmDaoHibernate() {
        super(OnmsAlarm.class);
    }

    public OnmsAlarm findByReductionKey(String reductionKey) {
        String hql = "from OnmsAlarm as alarms where alarms.reductionKey = ?";
        return (OnmsAlarm)super.findUnique(hql, reductionKey);
    }

    public List<AlarmSummary> getNodeAlarmSummariesIncludeAcknowledgedOnes(List<Integer> nodeIds) {
        if (nodeIds.size() < 1) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT new org.opennms.netmgt.model.alarm.AlarmSummary( node.id, node.label, min(alarm.lastEventTime), max(alarm.severity), (count(*) - count(alarm.alarmAckTime)) ) ");
        sql.append("FROM OnmsAlarm AS alarm ");
        sql.append("LEFT JOIN alarm.node AS node ");
        sql.append("WHERE node.id IS NOT NULL AND alarm.severity > 3 ");
        if (nodeIds.size() == 1) {
            sql.append("AND node.id = " + nodeIds.get(0) + " ");
        } else {
            sql.append("AND node.id in (");
            for (int i = 0; i < nodeIds.size(); ++i) {
                sql.append(nodeIds.get(i));
                if (i >= nodeIds.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
        }
        sql.append("GROUP BY node.id, node.label ");
        return this.findObjects(AlarmSummary.class, sql.toString(), new Object[0]);
    }

    public List<EdgeAlarmStatusSummary> getLldpEdgeAlarmSummaries(List<Integer> lldpLinkIds) {
        if (lldpLinkIds.size() < 1) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT new org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary( LEAST(s.id, t.id), GREATEST(s.id, t.id), alarm.uei)\n");
        sql.append("FROM LldpLink as s\n");
        sql.append("LEFT JOIN org.opennms.netmgt.model.LldpLink as t\n");
        sql.append("LEFT JOIN\n");
        sql.append("  OnmsAlarm as alarm\n");
        sql.append("with\n");
        sql.append(" alarm.node.id = s.node.id AND\n");
        sql.append(" s.lldpPortIfindex = alarm.ifindex\n");
        sql.append("GROUP BY\n");
        sql.append(" s.id,\n");
        sql.append(" t.id,\n");
        sql.append(" s.node.id,\n");
        sql.append(" t.node.id,\n");
        sql.append(" alarm.uei,\n");
        sql.append(" alarm.lastEventTime\n");
        sql.append("ORDER BY\n");
        sql.append(" alarm.lastEventTime DESC limit 1");
        return this.findObjects(EdgeAlarmStatusSummary.class, sql.toString(), new Object[0]);
    }

    public List<AlarmSummary> getNodeAlarmSummaries() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT new org.opennms.netmgt.model.alarm.AlarmSummary(node.id, node.label, min(alarm.lastEventTime), max(alarm.severity), count(*)) ");
        sql.append("FROM OnmsAlarm AS alarm ");
        sql.append("LEFT JOIN alarm.node AS node ");
        sql.append("WHERE node.id IS NOT NULL AND alarm.severity > 3 AND alarm.alarmAckTime IS NULL ");
        sql.append("GROUP BY node.id, node.label ");
        sql.append("ORDER BY min(alarm.lastEventTime) DESC, node.label ASC");
        return this.findObjects(AlarmSummary.class, sql.toString(), new Object[0]);
    }

    public List<HeatMapElement> getHeatMapItemsForEntity(final String entityNameColumn, final String entityIdColumn, boolean processAcknowledgedAlarms, final String restrictionColumn, final String restrictionValue, String ... groupByColumns) {
        String grouping = "";
        if (groupByColumns != null && groupByColumns.length > 0) {
            for (String groupByColumn : groupByColumns) {
                if (!"".equals(grouping)) {
                    grouping = grouping + ", ";
                }
                grouping = grouping + groupByColumn;
            }
        } else {
            grouping = entityNameColumn + ", " + entityIdColumn;
        }
        final String groupByClause = grouping;
        final String maximumSeverityQuery = processAcknowledgedAlarms ? "max(distinct greatest(alarms.severity,3)) as maxSeverity " : "max(distinct case when alarms.alarmacktime is not null then 3 else greatest(alarms.severity,3) end) as maxSeverity ";
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<HeatMapElement>>(){

            public List<HeatMapElement> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createSQLQuery("select coalesce(" + entityNameColumn + ",'Uncategorized'), " + entityIdColumn + ", " + "count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) as servicesTotal, " + "count(distinct node.nodeid) as nodeTotalCount, " + maximumSeverityQuery + "from node " + "left join category_node using (nodeid) " + "left join categories using (categoryid) " + "left outer join ipinterface using (nodeid) " + "left outer join ifservices on (ifservices.ipinterfaceid = ipinterface.id) " + "left outer join service on (ifservices.serviceid = service.serviceid) " + "left outer join alarms on (alarms.nodeid = node.nodeid and alarms.alarmtype in (1,3)) " + "where nodeType <> 'D' " + (restrictionColumn != null ? "and coalesce(" + restrictionColumn + ",'Uncategorized')='" + restrictionValue + "' " : "") + "group by " + groupByClause + " having count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) > 0").setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 5152094813503430377L;

                    public Object transformTuple(Object[] tuple, String[] aliases) {
                        return new HeatMapElement((String)tuple[0], (Number)tuple[1], (Number)tuple[2], (Number)tuple[3], (Number)tuple[4]);
                    }

                    public List transformList(List collection) {
                        return collection;
                    }
                }).list();
            }
        });
    }
}

