/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.util.AutoAction;
import org.opennms.netmgt.dao.util.Correlation;
import org.opennms.netmgt.dao.util.Forward;
import org.opennms.netmgt.dao.util.OperatorAction;
import org.opennms.netmgt.dao.util.SnmpInfo;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.processor.EventWriter;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.events.api.EventProcessorException;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Snmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.util.Assert;

public class HibernateEventWriter
implements EventWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateEventWriter.class);
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private DistPollerDao distPollerDao;
    @Autowired
    private EventDao eventDao;
    @Autowired
    private ServiceTypeDao serviceTypeDao;
    @Autowired
    private EventUtil eventUtil;

    private static boolean checkEventSanityAndDoWeProcess(Event event, String logPrefix) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)event.getLogmsg(), (String)"event does not have a logmsg");
        if ("donotpersist".equals(event.getLogmsg().getDest()) || "suppress".equals(event.getLogmsg().getDest())) {
            LOG.debug("{}: uei '{}' marked as '{}'; not processing event.", new Object[]{logPrefix, event.getUei(), event.getLogmsg().getDest()});
            return false;
        }
        return true;
    }

    public void process(Header eventHeader, Event event) throws EventProcessorException {
        if (!HibernateEventWriter.checkEventSanityAndDoWeProcess(event, "HibernateEventWriter")) {
            return;
        }
        LOG.debug("HibernateEventWriter: processing {}, nodeid: {}, ipaddr: {}, serviceid: {}, time: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService(), event.getTime()});
        try {
            this.insertEvent(eventHeader, event);
        }
        catch (DeadlockLoserDataAccessException e) {
            throw new EventProcessorException("Encountered deadlock when inserting event: " + event.toString(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new EventProcessorException("Unexpected exception while storing event: " + event.toString(), e);
        }
    }

    private void insertEvent(Header eventHeader, Event event) {
        OnmsEvent ovent = new OnmsEvent();
        ovent.setEventUei(EventDatabaseConstants.format((String)event.getUei(), (int)256));
        if (event.hasNodeid()) {
            ovent.setNode((OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(event.getNodeid().intValue())));
        }
        ovent.setEventTime(event.getTime());
        ovent.setEventHost(EventDatabaseConstants.format((String)this.eventUtil.getEventHost(event), (int)256));
        ovent.setEventSource(EventDatabaseConstants.format((String)event.getSource(), (int)128));
        ovent.setIpAddr(event.getInterfaceAddress());
        if (event.hasIfIndex()) {
            ovent.setIfIndex(event.getIfIndex());
        } else {
            ovent.setIfIndex(null);
        }
        if (eventHeader != null && eventHeader.getDpName() != null && !"".equals(eventHeader.getDpName().trim())) {
            ovent.setDistPoller((OnmsDistPoller)this.distPollerDao.get((Serializable)((Object)eventHeader.getDpName())));
        }
        if (ovent.getDistPoller() == null && event.getDistPoller() != null && !"".equals(event.getDistPoller().trim())) {
            ovent.setDistPoller((OnmsDistPoller)this.distPollerDao.get((Serializable)((Object)event.getDistPoller())));
        }
        if (ovent.getDistPoller() == null) {
            ovent.setDistPoller(this.distPollerDao.whoami());
        }
        ovent.setEventSnmpHost(EventDatabaseConstants.format((String)event.getSnmphost(), (int)256));
        ovent.setServiceType(this.serviceTypeDao.findByName(event.getService()));
        ovent.setEventSnmp(event.getSnmp() == null ? null : SnmpInfo.format((Snmp)event.getSnmp(), (int)256));
        String parametersString = EventParameterUtils.format((Event)event);
        ovent.setEventParms(EventDatabaseConstants.format((String)parametersString, (int)0));
        ovent.setEventCreateTime(new Date());
        ovent.setEventDescr(EventDatabaseConstants.format((String)event.getDescr(), (int)0));
        ovent.setEventLogGroup(event.getLoggroupCount() > 0 ? EventDatabaseConstants.format((String[])event.getLoggroup(), (int)32) : null);
        if (event.getLogmsg() != null) {
            ovent.setEventLogMsg(EventDatabaseConstants.format((String)event.getLogmsg().getContent(), (int)0));
            String logdest = event.getLogmsg().getDest();
            if ("logndisplay".equals(logdest)) {
                ovent.setEventLog(String.valueOf('Y'));
                ovent.setEventDisplay(String.valueOf('Y'));
            } else if ("logonly".equals(logdest)) {
                ovent.setEventLog(String.valueOf('Y'));
                ovent.setEventDisplay(String.valueOf('N'));
            } else if ("displayonly".equals(logdest)) {
                ovent.setEventLog(String.valueOf('N'));
                ovent.setEventDisplay(String.valueOf('Y'));
            } else if ("suppress".equals(logdest)) {
                ovent.setEventLog(String.valueOf('N'));
                ovent.setEventDisplay(String.valueOf('N'));
            }
        } else {
            ovent.setEventLogMsg(null);
            ovent.setEventLog(String.valueOf('Y'));
            ovent.setEventDisplay(String.valueOf('Y'));
        }
        ovent.setEventSeverity(Integer.valueOf(OnmsSeverity.get((String)event.getSeverity()).getId()));
        ovent.setEventPathOutage(event.getPathoutage() != null ? EventDatabaseConstants.format((String)event.getPathoutage(), (int)1024) : null);
        ovent.setEventCorrelation(event.getCorrelation() != null ? Correlation.format((org.opennms.netmgt.xml.event.Correlation)event.getCorrelation(), (int)1024) : null);
        ovent.setEventSuppressedCount(null);
        ovent.setEventOperInstruct(EventDatabaseConstants.format((String)event.getOperinstruct(), (int)0));
        ovent.setEventAutoAction(event.getAutoactionCount() > 0 ? AutoAction.format((Autoaction[])event.getAutoaction(), (int)256) : null);
        if (event.getOperactionCount() > 0) {
            ArrayList<Operaction> a = new ArrayList<Operaction>();
            ArrayList<String> b = new ArrayList<String>();
            for (Operaction eoa : event.getOperactionCollection()) {
                a.add(eoa);
                b.add(eoa.getMenutext());
            }
            ovent.setEventOperAction(OperatorAction.format(a, (int)256));
            ovent.setEventOperActionMenuText(EventDatabaseConstants.format(b, (int)256));
        } else {
            ovent.setEventOperAction(null);
            ovent.setEventOperActionMenuText(null);
        }
        ovent.setEventNotification(null);
        if (event.getTticket() != null) {
            ovent.setEventTTicket(EventDatabaseConstants.format((String)event.getTticket().getContent(), (int)128));
            ovent.setEventTTicketState(Integer.valueOf("on".equals(event.getTticket().getState()) ? 1 : 0));
        } else {
            ovent.setEventTTicket(null);
            ovent.setEventTTicketState(null);
        }
        ovent.setEventForward(event.getForwardCount() > 0 ? Forward.format((org.opennms.netmgt.xml.event.Forward[])event.getForward(), (int)256) : null);
        ovent.setEventMouseOverText(EventDatabaseConstants.format((String)event.getMouseovertext(), (int)64));
        if (event.getAutoacknowledge() != null && "on".equals(event.getAutoacknowledge().getState())) {
            ovent.setEventAckUser(EventDatabaseConstants.format((String)event.getAutoacknowledge().getContent(), (int)256));
            ovent.setEventAckTime(ovent.getEventCreateTime());
        } else {
            ovent.setEventAckUser(null);
            ovent.setEventAckTime(null);
        }
        this.eventDao.save((Object)ovent);
        this.eventDao.flush();
        event.setDbid(ovent.getId());
    }
}

