/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.config.scriptd.Engine;
import org.opennms.netmgt.config.scriptd.EventScript;
import org.opennms.netmgt.config.scriptd.ReloadScript;
import org.opennms.netmgt.config.scriptd.StartScript;
import org.opennms.netmgt.config.scriptd.StopScript;
import org.opennms.netmgt.config.scriptd.Uei;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Executor
implements Runnable,
PausableFiber {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    private final FifoQueue<Event> m_execQ;
    private Thread m_worker;
    private final String m_name;
    private int m_status;
    private ScriptdConfigFactory m_config;
    private List<EventScript> m_eventScripts;
    private Map<String, List<EventScript>> m_eventScriptMap;
    private BSFManager m_mgr;
    private NodeDao m_nodeDao;

    Executor(FifoQueue<Event> execQ, ScriptdConfigFactory config, NodeDao nodeDao) {
        this.m_execQ = execQ;
        this.m_config = config;
        this.loadConfig();
        this.m_worker = null;
        this.m_name = "Scriptd-Executor";
        this.m_mgr = null;
        this.m_status = 0;
        this.m_nodeDao = nodeDao;
    }

    private void loadConfig() {
        EventScript[] scripts = this.m_config.getEventScripts();
        this.m_eventScripts = new ArrayList<EventScript>();
        this.m_eventScriptMap = new ConcurrentHashMap<String, List<EventScript>>();
        for (int i = 0; i < scripts.length; ++i) {
            Uei[] ueis = scripts[i].getUei();
            if (ueis.length == 0) {
                this.m_eventScripts.add(scripts[i]);
                continue;
            }
            for (int j = 0; j < ueis.length; ++j) {
                String uei = ueis[j].getName();
                List<EventScript> list = this.m_eventScriptMap.get(uei);
                if (list == null) {
                    list = new ArrayList<EventScript>();
                    list.add(scripts[i]);
                    this.m_eventScriptMap.put(uei, list);
                    continue;
                }
                list.add(scripts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Executor executor = this;
        synchronized (executor) {
            this.m_status = 2;
        }
        while (true) {
            Script script;
            executor = this;
            synchronized (executor) {
                if (this.m_status == 3 || this.m_status == 4) {
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    this.m_status = 2;
                }
            }
            Event event = null;
            try {
                event = (Event)this.m_execQ.remove(1000L);
                if (event == null) {
                    continue;
                }
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (FifoQueueException ex) {
                LOG.warn("The input event queue has errors, exiting...", (Throwable)ex);
                break;
            }
            if (this.isReloadConfigEvent(event)) {
                try {
                    ScriptdConfigFactory.reload();
                    this.m_config = ScriptdConfigFactory.getInstance();
                    this.loadConfig();
                    ReloadScript[] reloadScripts = this.m_config.getReloadScripts();
                    for (int i = 0; i < reloadScripts.length; ++i) {
                        try {
                            this.m_mgr.exec(reloadScripts[i].getLanguage(), "", 0, 0, (Object)reloadScripts[i].getContent());
                            continue;
                        }
                        catch (BSFException ex) {
                            LOG.error("Reload script[{}] failed.", (Object)i, (Object)ex);
                        }
                    }
                    LOG.debug("Script configuration reloaded");
                }
                catch (Throwable ex) {
                    LOG.error("Unable to reload ScriptD configuration: ", ex);
                }
            }
            Script[] attachedScripts = event.getScript();
            List<EventScript> mapScripts = null;
            try {
                mapScripts = this.m_eventScriptMap.get(event.getUei());
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (attachedScripts.length <= 0 && mapScripts == null && this.m_eventScripts.size() <= 0) continue;
            LOG.debug("Executing scripts for: {}", (Object)event.getUei());
            this.m_mgr.registerBean("event", (Object)event);
            OnmsNode node = null;
            if (event.hasNodeid()) {
                Long nodeLong = event.getNodeid();
                Integer nodeInt = nodeLong.intValue();
                node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeInt);
                this.m_mgr.registerBean("node", (Object)node);
            }
            LOG.debug("Executing attached scripts");
            if (attachedScripts.length > 0) {
                for (int i = 0; i < attachedScripts.length; ++i) {
                    try {
                        script = attachedScripts[i];
                        this.m_mgr.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        continue;
                    }
                    catch (BSFException ex) {
                        LOG.error("Attached script [{}] execution failed", (Object)i, (Object)ex);
                    }
                }
            }
            LOG.debug("Executing mapped scripts");
            if (mapScripts != null) {
                for (int i = 0; i < mapScripts.size(); ++i) {
                    try {
                        script = mapScripts.get(i);
                        this.m_mgr.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        continue;
                    }
                    catch (BSFException ex) {
                        LOG.error("UEI-specific event handler script execution failed: {}", (Object)event.getUei(), (Object)ex);
                    }
                }
            }
            LOG.debug("Executing global scripts");
            for (int i = 0; i < this.m_eventScripts.size(); ++i) {
                try {
                    script = this.m_eventScripts.get(i);
                    this.m_mgr.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                    continue;
                }
                catch (BSFException ex) {
                    LOG.error("Non-UEI-specific event handler script [{}] execution failed", (Object)i, (Object)ex);
                }
            }
            if (node != null) {
                this.m_mgr.unregisterBean("node");
            }
            this.m_mgr.unregisterBean("event");
            LOG.debug("Finished executing scripts for: {}", (Object)event.getUei());
        }
        executor = this;
        synchronized (executor) {
            this.m_status = 4;
        }
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Scriptd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
        } else if ("uei.opennms.org/internal/reloadScriptConfig".equals(event.getUei())) {
            isTarget = true;
        }
        return isTarget;
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already been run");
        }
        this.m_status = 1;
        Engine[] engines = this.m_config.getEngines();
        for (int i = 0; i < engines.length; ++i) {
            Engine engine = engines[i];
            LOG.debug("Registering engine: {}", (Object)engine.getLanguage());
            String[] extensions = null;
            String extensionList = engines[i].getExtensions();
            if (extensionList != null) {
                StringTokenizer st = new StringTokenizer(extensionList);
                extensions = new String[st.countTokens()];
                int j = 0;
                while (st.hasMoreTokens()) {
                    extensions[j++] = st.nextToken();
                }
            }
            BSFManager.registerScriptingEngine((String)engines[i].getLanguage(), (String)engines[i].getClassName(), (String[])extensions);
        }
        this.m_mgr = new BSFManager();
        this.m_mgr.registerBean("log", (Object)LOG);
        StartScript[] startScripts = this.m_config.getStartScripts();
        for (int i = 0; i < startScripts.length; ++i) {
            try {
                this.m_mgr.exec(startScripts[i].getLanguage(), "", 0, 0, (Object)startScripts[i].getContent());
                continue;
            }
            catch (BSFException ex) {
                LOG.error("Start script[{}] failed.", (Object)i, (Object)ex);
            }
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
    }

    public synchronized void stop() {
        Logger log = (Logger)this.m_mgr.lookupBean("log");
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been run");
        }
        if (this.m_status != 4) {
            this.m_status = 3;
        }
        if (this.m_worker.isAlive()) {
            this.m_worker.interrupt();
        }
        StopScript[] stopScripts = this.m_config.getStopScripts();
        this.notifyAll();
        for (int i = 0; i < stopScripts.length; ++i) {
            try {
                this.m_mgr.exec(stopScripts[i].getLanguage(), "", 0, 0, (Object)stopScripts[i].getContent());
                continue;
            }
            catch (BSFException ex) {
                LOG.error("Stop script[{}] failed.", (Object)i, (Object)ex);
            }
        }
        LOG.debug("Stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 2 || this.m_status == 7) {
            this.m_status = 5;
            this.notifyAll();
        }
    }

    public synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 6 || this.m_status == 5) {
            this.m_status = 7;
            this.notifyAll();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }
}

