/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrcCatNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IrcCatNotificationStrategy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(List<Argument> arguments) {
        Socket s = null;
        try {
            String message = this.buildMessage(arguments);
            s = new Socket(this.getRemoteAddr(), this.getRemotePort());
            PrintStream stream = new PrintStream(s.getOutputStream());
            stream.println(message);
            stream.close();
        }
        catch (Throwable e) {
            LOG.error("send: Error sending IRCcat notification", e);
            int n = 1;
            return n;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.error("send: Error closing IRCcat socket", (Throwable)e);
                }
            }
        }
        return 0;
    }

    private InetAddress getRemoteAddr() throws UnknownHostException {
        return InetAddressUtils.addr((String)System.getProperty("irccat.host", "127.0.0.1"));
    }

    private int getRemotePort() {
        return Integer.parseInt(System.getProperty("irccat.port", "12345"));
    }

    private String buildMessage(List<Argument> arguments) {
        String recipient = null;
        String message = null;
        for (Argument arg : arguments) {
            if ("-email".equals(arg.getSwitch())) {
                recipient = arg.getValue();
                continue;
            }
            if ("-tm".equals(arg.getSwitch())) {
                message = arg.getValue();
                continue;
            }
            if ("-nm".equals(arg.getSwitch())) {
                message = arg.getValue();
                continue;
            }
            throw new IllegalArgumentException("Unsupported notification argument switch '" + arg.getSwitch() + "'");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("no recipient specified, but is required");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message specified, but is required");
        }
        return recipient + " " + message;
    }
}

