/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dot1dBaseTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(Dot1dBaseTracker.class);
    public static final String BASE_BRIDGE_ADDRESS = "dot1dBaseBridgeAddress";
    public static final String BASE_NUM_PORTS = "dot1dBaseNumPorts";
    public static final String BASE_NUM_TYPE = "dot1dBaseType";
    public static final String STP_PROTOCOL_SPEC = "dot1dStpProtocolSpecification";
    public static final String STP_PRIORITY = "dot1dStpPriority";
    public static final String STP_DESIGNATED_ROOT = "dot1dStpDesignatedRoot";
    public static final String STP_ROOT_COST = "dot1dStpRootCost";
    public static final String STP_ROOT_PORT = "dot1dStpRootPort";
    public static NamedSnmpVar[] ms_elemList = null;
    private SnmpStore m_store = new SnmpStore(ms_elemList);

    public Dot1dBaseTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving do1dbase: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving do1dbase: {}", (Object)msg);
    }

    public String getBridgeAddress() {
        if (this.m_store.getValue(BASE_BRIDGE_ADDRESS) != null) {
            return this.m_store.getHexString(BASE_BRIDGE_ADDRESS);
        }
        return null;
    }

    public Integer getNumberOfPorts() {
        if (this.m_store.getValue(BASE_NUM_PORTS) != null) {
            return this.m_store.getInt32(BASE_NUM_PORTS);
        }
        return null;
    }

    public Integer getBridgeType() {
        if (this.m_store.getValue(BASE_NUM_TYPE) != null) {
            return this.m_store.getInt32(BASE_NUM_TYPE);
        }
        return null;
    }

    public Integer getStpProtocolSpecification() {
        if (this.m_store.getValue(STP_PROTOCOL_SPEC) != null) {
            return this.m_store.getInt32(STP_PROTOCOL_SPEC);
        }
        return null;
    }

    public Integer getStpPriority() {
        if (this.m_store.getValue(STP_PRIORITY) != null) {
            return this.m_store.getInt32(STP_PRIORITY);
        }
        return null;
    }

    public String getStpDesignatedRoot() {
        if (this.m_store.getValue(STP_DESIGNATED_ROOT) != null) {
            return this.m_store.getHexString(STP_DESIGNATED_ROOT);
        }
        return null;
    }

    public Integer getStpRootCost() {
        if (this.m_store.getValue(STP_ROOT_COST) != null) {
            return this.m_store.getInt32(STP_ROOT_COST);
        }
        return null;
    }

    public Integer getStpRootPort() {
        if (this.m_store.getValue(STP_ROOT_PORT) != null) {
            return this.m_store.getInt32(STP_ROOT_PORT);
        }
        return null;
    }

    public BridgeElement getBridgeElement() {
        BridgeElement bridge = new BridgeElement();
        bridge.setBaseBridgeAddress(this.getBridgeAddress());
        bridge.setBaseNumPorts(this.getNumberOfPorts());
        if (this.getBridgeType() != null) {
            bridge.setBaseType(BridgeElement.BridgeDot1dBaseType.get((Integer)this.getBridgeType()));
        }
        if (this.getStpProtocolSpecification() != null) {
            bridge.setStpProtocolSpecification(BridgeElement.BridgeDot1dStpProtocolSpecification.get((Integer)this.getStpProtocolSpecification()));
            bridge.setStpPriority(this.getStpPriority());
            bridge.setStpDesignatedRoot(this.getStpDesignatedRoot());
            bridge.setStpRootPort(this.getStpRootPort());
            bridge.setStpRootCost(this.getStpRootCost());
        }
        return bridge;
    }

    static {
        ms_elemList = new NamedSnmpVar[8];
        int ndx = 0;
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", BASE_BRIDGE_ADDRESS, ".1.3.6.1.2.1.17.1.1");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", BASE_NUM_PORTS, ".1.3.6.1.2.1.17.1.2");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", BASE_NUM_TYPE, ".1.3.6.1.2.1.17.1.3");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_PROTOCOL_SPEC, ".1.3.6.1.2.1.17.2.1");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_PRIORITY, ".1.3.6.1.2.1.17.2.2");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", STP_DESIGNATED_ROOT, ".1.3.6.1.2.1.17.2.5");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_ROOT_COST, ".1.3.6.1.2.1.17.2.6");
        Dot1dBaseTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_ROOT_PORT, ".1.3.6.1.2.1.17.2.7");
    }
}

