/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpVlanTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBasePortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryBridge
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridge.class);

    public NodeDiscoveryBridge(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        LOG.info("run: start: node discovery operations for bridge: '{}'", (Object)this.getNodeId());
        Date now = new Date();
        LOG.debug("run: collecting: {}", (Object)this.getPeer());
        Map<Integer, String> vlanmap = this.getVtpVlanMap();
        HashMap<Integer, Integer> bridgeifindex = new HashMap<Integer, Integer>();
        List<BridgeMacLink> bft = new ArrayList<BridgeMacLink>();
        if (vlanmap.isEmpty()) {
            bridgeifindex.putAll(this.walkDot1d(null, null));
            bft = this.walkDot1dTpFdp(null, bridgeifindex, bft, this.getPeer());
        } else {
            String community = this.getPeer().getReadCommunity();
            for (Map.Entry<Integer, String> entry : vlanmap.entrySet()) {
                LOG.debug("run: cisco vlan collection setting peer community: {} with VLAN {}", (Object)community, (Object)entry.getKey());
                SnmpAgentConfig peer = this.getPeer();
                peer.setReadCommunity(community + "@" + entry.getKey());
                bridgeifindex.putAll(this.walkDot1d(entry.getKey(), entry.getValue()));
                bft = this.walkDot1dTpFdp(entry.getKey(), bridgeifindex, bft, peer);
            }
        }
        LOG.debug("run: found on node: '{}' bridge ifindex map {}", (Object)this.getNodeId(), bridgeifindex);
        bft = this.walkDot1qTpFdb(bridgeifindex, bft);
        this.m_linkd.getQueryManager().store(this.getNodeId(), bft);
        LOG.debug("run: reconciling bridge: '{}' time {}", (Object)this.getNodeId(), (Object)now);
        this.m_linkd.getQueryManager().reconcileBridge(this.getNodeId(), now);
        LOG.debug("run: updating topology bridge: '{}'", (Object)this.getNodeId());
        LOG.info("run: end: node discovery operations for bridge: '{}'", (Object)this.getNodeId());
    }

    private Map<Integer, String> getVtpVlanMap() {
        final HashMap<Integer, String> vlanmap = new HashMap<Integer, String>();
        String trackerName = "vtpVersion";
        CiscoVtpTracker vtpStatus = new CiscoVtpTracker();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)vtpStatus);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return vlanmap;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return vlanmap;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return vlanmap;
        }
        if (vtpStatus.getVtpVersion() == null) {
            LOG.info("run: cisco vtp mib not supported, on: {}", (Object)this.getNodeId());
            return vlanmap;
        }
        LOG.info("run: cisco vtp mib supported, on: {}", (Object)this.getNodeId());
        LOG.info("run: walking cisco vtp, on: {}", (Object)this.getNodeId());
        trackerName = "ciscoVtpVlan";
        CiscoVtpVlanTableTracker ciscoVtpVlanTableTracker = new CiscoVtpVlanTableTracker(){

            @Override
            public void processCiscoVtpVlanRow(CiscoVtpVlanTableTracker.CiscoVtpVlanRow row) {
                if (row.isTypeEthernet() && row.isStatusOperational()) {
                    vlanmap.put(row.getVlanIndex(), row.getVlanName());
                }
            }
        };
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)ciscoVtpVlanTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
        return vlanmap;
    }

    protected Map<Integer, Integer> walkDot1d(Integer vlan, String vlanname) {
        LOG.debug("run: Bridge Linkd node scan : ready to walk dot1d data on {}, vlan {}, vlanname {}.", new Object[]{this.getNodeId(), vlan, vlanname});
        String trackerName = "dot1dbase";
        Dot1dBaseTracker dot1dbase = new Dot1dBaseTracker();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)dot1dbase);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return new HashMap<Integer, Integer>();
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return new HashMap<Integer, Integer>();
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return new HashMap<Integer, Integer>();
        }
        BridgeElement bridge = dot1dbase.getBridgeElement();
        bridge.setVlan(vlan);
        bridge.setVlanname(vlanname);
        if (bridge.getBaseBridgeAddress() == null) {
            LOG.info("run: base bridge address is null: bridge mib not supported on: {}", (Object)this.getNodeId());
            return new HashMap<Integer, Integer>();
        }
        if (!InetAddressUtils.isValidBridgeAddress((String)bridge.getBaseBridgeAddress())) {
            LOG.info("run: bridge not supported, base address identifier {} is not valid on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)this.getNodeId());
            return new HashMap<Integer, Integer>();
        }
        if (bridge.getBaseNumPorts() == null || bridge.getBaseNumPorts() == 0) {
            LOG.info("run: bridge {} has 0 port active, on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)this.getNodeId());
            return new HashMap<Integer, Integer>();
        }
        LOG.info("run: bridge {} has is if type {}, on: {}", new Object[]{dot1dbase.getBridgeAddress(), BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)dot1dbase.getBridgeType()), this.getNodeId()});
        if (bridge.getBaseType() == BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_SOURCEROUTE_ONLY) {
            LOG.info("run: {}: source route only type bridge, on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)this.getNodeId());
            return new HashMap<Integer, Integer>();
        }
        this.m_linkd.getQueryManager().store(this.getNodeId(), bridge);
        Map<Integer, Integer> bridgetoifindex = this.walkDot1dBasePortTable();
        LOG.debug("run: found on node: '{}' vlan: '{}', bridge ifindex map {}", new Object[]{this.getNodeId(), vlanname, bridgetoifindex});
        if (!InetAddressUtils.isValidStpBridgeId((String)bridge.getStpDesignatedRoot())) {
            LOG.info("run: invalid Stp designated root: spanning tree not supported on: {}", (Object)this.getNodeId());
        } else if (bridge.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()))) {
            LOG.info("run: designated root of spanning tree is itself on bridge {}, on: {}", (Object)bridge.getStpDesignatedRoot(), (Object)this.getNodeId());
        } else {
            this.walkSpanningTree(bridge.getBaseBridgeAddress(), vlan, bridgetoifindex);
        }
        return bridgetoifindex;
    }

    private Map<Integer, Integer> walkDot1dBasePortTable() {
        final HashMap<Integer, Integer> bridgetoifindex = new HashMap<Integer, Integer>();
        String trackerName = "dot1dBasePortTable";
        Dot1dBasePortTableTracker dot1dBasePortTableTracker = new Dot1dBasePortTableTracker(){

            @Override
            public void processDot1dBasePortRow(Dot1dBasePortTableTracker.Dot1dBasePortRow row) {
                bridgetoifindex.put(row.getBaseBridgePort(), row.getBaseBridgePortIfindex());
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)dot1dBasePortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
        return bridgetoifindex;
    }

    private List<BridgeMacLink> walkDot1dTpFdp(final Integer vlan, final Map<Integer, Integer> bridgeifindex, final List<BridgeMacLink> bft, SnmpAgentConfig peer) {
        String trackerName = "dot1dTbFdbPortTable";
        Dot1dTpFdbTableTracker stpPortTableTracker = new Dot1dTpFdbTableTracker(){

            @Override
            public void processDot1dTpFdbRow(Dot1dTpFdbTableTracker.Dot1dTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.warn("processDot1dTpFdbRow: row has null status. mac {}: vlan {}: on port {}", new Object[]{row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.warn("processDot1dTpFdbRow: row has null bridge port.  mac {}: vlan {}: on port {} status {}", new Object[]{row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.warn("processDot1dTpFdbRow: row has invalid mac. mac {}: vlan {}: on port {} ifindex {} status {}", new Object[]{row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setVlan(vlan);
                if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    LOG.warn("processDot1dTpFdbRow: row has invalid bridge port no ifindex found. mac {}: vlan {}: on port {} ifindex {} status {}", new Object[]{row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                LOG.info("processDot1dTpFdbRow: row processed: mac {}: vlan {}: on port {} ifindex {} status {}", new Object[]{link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)stpPortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return bft;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return bft;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return bft;
        }
        return bft;
    }

    private List<BridgeMacLink> walkDot1qTpFdb(final Map<Integer, Integer> bridgeifindex, final List<BridgeMacLink> bft) {
        String trackerName = "dot1qTbFdbPortTable";
        Dot1qTpFdbTableTracker dot1qTpFdbTableTracker = new Dot1qTpFdbTableTracker(){

            @Override
            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.warn("processDot1qTpFdbRow: row has null status. mac {}: on port {}", (Object)row.getDot1qTpFdbAddress(), (Object)row.getDot1qTpFdbPort());
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.warn("processDot1qTpFdbRow: row has null bridge port.  mac {}: on port {} status {}", new Object[]{row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.warn("processDot1qTpFdbRow: row has invalid mac. mac {}: on port {} ifindex {} status {}", new Object[]{row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    LOG.warn("processDot1qTpFdbRow: row has invalid bridgeport no ifindex found. mac {}: on port {} ifindex {} status {}", new Object[]{row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                LOG.info("processDot1qTpFdbRow: row processed: mac {}: vlan {}: on port {} ifindex {} status {}", new Object[]{link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)dot1qTpFdbTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return bft;
        }
        return bft;
    }

    private void walkSpanningTree(final String baseBridgeAddress, final Integer vlan, final Map<Integer, Integer> bridgeifindex) {
        String trackerName = "dot1dStpPortTable";
        Dot1dStpPortTableTracker stpPortTableTracker = new Dot1dStpPortTableTracker(){

            @Override
            public void processDot1dStpPortRow(Dot1dStpPortTableTracker.Dot1dStpPortRow row) {
                BridgeStpLink link = row.getLink();
                link.setVlan(vlan);
                link.setStpPortIfIndex((Integer)bridgeifindex.get(link.getStpPort()));
                if (InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedRoot()) && InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedBridge()) && !baseBridgeAddress.equals(link.getDesignatedBridgeAddress())) {
                    NodeDiscoveryBridge.this.m_linkd.getQueryManager().store(NodeDiscoveryBridge.this.getNodeId(), link);
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)stpPortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable BridgeLinkNodeDiscovery ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "BridgeLinkDiscovery";
    }
}

