/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisISAdjTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IsisISAdjTableTracker.class);
    public static final SnmpObjId ISIS_IS_ADJ_TABLE = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1");
    public static final SnmpObjId ISIS_IS_ADJ_STATE = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.2");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_SNPAADDR = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.4");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_SYSTYPE = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.5");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_SYSID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.6");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_EXTENDED_CIRCID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.7");
    public static final SnmpObjId[] isisIsAdjtable_elemList = new SnmpObjId[]{ISIS_IS_ADJ_STATE, ISIS_IS_ADJ_NBR_SNPAADDR, ISIS_IS_ADJ_NBR_SYSTYPE, ISIS_IS_ADJ_NBR_SYSID, ISIS_IS_ADJ_NBR_EXTENDED_CIRCID};

    public IsisISAdjTableTracker() {
        super(isisIsAdjtable_elemList);
    }

    public IsisISAdjTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, isisIsAdjtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IsIsAdjRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIsisAdjRow((IsIsAdjRow)row);
    }

    public void processIsisAdjRow(IsIsAdjRow row) {
    }

    public static class IsIsAdjRow
    extends SnmpRowResult {
        public IsIsAdjRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getIsisCircIndex() {
            return this.getInstance().getSubIdAt(0);
        }

        public Integer getIsisISAdjIndex() {
            return this.getInstance().getLastSubId();
        }

        public Integer getIsisISAdjStatus() {
            return this.getValue(ISIS_IS_ADJ_STATE).toInt();
        }

        public String getIsisISAdjNeighSnpaAddress() {
            return this.getValue(ISIS_IS_ADJ_NBR_SNPAADDR).toHexString();
        }

        public Integer getIsisISAdjNeighSysType() {
            return this.getValue(ISIS_IS_ADJ_NBR_SYSTYPE).toInt();
        }

        public String getIsisISAdjNeighSysID() {
            return this.getValue(ISIS_IS_ADJ_NBR_SYSID).toHexString();
        }

        public Integer getIsisISAdjNbrExtendedCircID() {
            return this.getValue(ISIS_IS_ADJ_NBR_EXTENDED_CIRCID).toInt();
        }

        public IsIsLink getIsisLink() {
            LOG.info("getIsisLink: row count: {}", (Object)this.getColumnCount());
            IsIsLink link = new IsIsLink();
            link.setIsisCircIndex(this.getIsisCircIndex());
            LOG.info("getIsisLink: IS-IS Circ Index: {}", (Object)link.getIsisCircIndex());
            link.setIsisISAdjIndex(this.getIsisISAdjIndex());
            LOG.info("getIsisLink: IS-IS IS Adj Index: {}", (Object)link.getIsisISAdjIndex());
            link.setIsisISAdjState(IsIsLink.IsisISAdjState.get((Integer)this.getIsisISAdjStatus()));
            LOG.info("getIsisLink: IS-IS IS Adj State: {}", (Object)IsIsLink.IsisISAdjState.getTypeString((Integer)this.getIsisISAdjStatus()));
            link.setIsisISAdjNeighSNPAAddress(this.getIsisISAdjNeighSnpaAddress());
            LOG.info("getIsisLink: IS-IS IS Adj Neigh SNPA Address: {}", (Object)link.getIsisISAdjNeighSNPAAddress());
            link.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.get((Integer)this.getIsisISAdjNeighSysType()));
            LOG.info("getIsisLink: IS-IS IS Adj Neigh Sys Type: {}", (Object)IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)this.getIsisISAdjNeighSysType()));
            link.setIsisISAdjNeighSysID(this.getIsisISAdjNeighSysID());
            LOG.info("getIsisLink: IS-IS IS Adj Neigh Sys ID: {}", (Object)link.getIsisISAdjNeighSysID());
            link.setIsisISAdjNbrExtendedCircID(this.getIsisISAdjNbrExtendedCircID());
            LOG.info("getIsisLink: IS-IS IS Adj Nbr Extended Circ ID: {}", (Object)link.getIsisISAdjNbrExtendedCircID());
            return link;
        }
    }
}

