/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Executor;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ServiceBase;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;
import org.fusesource.hawtdispatch.transport.UdpTransport;

public class UdpTransportServer
extends ServiceBase
implements TransportServer {
    private final String bindScheme;
    private final InetSocketAddress bindAddress;
    private DatagramChannel channel;
    private TransportServerListener listener;
    private DispatchQueue dispatchQueue;
    private Executor blockingExecutor;
    private UdpTransport transport;

    public UdpTransportServer(URI location) throws UnknownHostException {
        this.bindScheme = location.getScheme();
        String host = location.getHost();
        host = host == null || host.length() == 0 ? "::" : host;
        this.bindAddress = new InetSocketAddress(InetAddress.getByName(host), location.getPort());
    }

    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    protected void _start(Task onCompleted) {
        this.accept();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    private void queueAccept() {
        this.dispatchQueue.execute(new Task(){

            public void run() {
                UdpTransportServer.this.accept();
            }
        });
    }

    private void accept() {
        if (this.getServiceState().isStarted() || this.getServiceState().isStarting()) {
            try {
                UdpTransport udpTransport;
                this.transport = udpTransport = this.createTransport();
                this.transport.onDispose = new Task(){

                    public void run() {
                        UdpTransportServer.this.queueAccept();
                    }
                };
                this.channel = DatagramChannel.open();
                this.channel.socket().bind(this.bindAddress);
                this.transport.connected(this.channel);
                this.listener.onAccept(this.transport);
            }
            catch (Exception e) {
                this.listener.onAcceptError(e);
            }
        }
    }

    protected UdpTransport createTransport() {
        UdpTransport transport = new UdpTransport();
        transport.setBlockingExecutor(this.blockingExecutor);
        transport.setDispatchQueue(this.dispatchQueue);
        return transport;
    }

    protected void _stop(Task onCompleted) {
        this.transport.stop(onCompleted);
    }

    public void suspend() {
        this.dispatchQueue.suspend();
    }

    public void resume() {
        this.dispatchQueue.resume();
    }

    public String getBoundAddress() {
        try {
            String host = this.bindAddress.getAddress().getHostAddress();
            int port = this.channel.socket().getLocalPort();
            return new URI(this.bindScheme, null, host, port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getBoundAddress();
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }
}

