/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.netmgt.poller.remote.ServicePollState;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedEvent;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedListener;
import org.opennms.netmgt.poller.remote.TimeAdjustment;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.opennms.netmgt.poller.remote.support.FatalExceptionOccurred;
import org.opennms.netmgt.poller.remote.support.PollerFrontEndState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultPollerFrontEnd
implements PollerFrontEnd,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollerFrontEnd.class);
    private PollerFrontEndState m_state = new Initial();
    private PollerBackEnd m_backEnd;
    private PollerSettings m_pollerSettings;
    private PollService m_pollService;
    private TimeAdjustment m_timeAdjustment;
    private LinkedList<PropertyChangeListener> m_propertyChangeListeners = new LinkedList();
    private LinkedList<ServicePollStateChangedListener> m_servicePollStateChangedListeners = new LinkedList();
    private LinkedList<ConfigurationChangedListener> m_configChangeListeners = new LinkedList();
    private PollerConfiguration m_pollerConfiguration;
    private Map<Integer, ServicePollState> m_pollState = new LinkedHashMap<Integer, ServicePollState>();

    @Override
    public void addConfigurationChangedListener(ConfigurationChangedListener l) {
        this.m_configChangeListeners.addFirst(l);
    }

    private void doResume() {
        this.doLoadConfig();
    }

    private void doPause() {
    }

    private void doDisconnected() {
        this.doLoadConfig();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.addFirst(listener);
    }

    @Override
    public void addServicePollStateChangedListener(ServicePollStateChangedListener listener) {
        this.m_servicePollStateChangedListeners.addFirst(listener);
    }

    public void afterPropertiesSet() {
        DefaultPollerFrontEnd.assertNotNull(this.m_timeAdjustment, "timeAdjustment");
        DefaultPollerFrontEnd.assertNotNull(this.m_backEnd, "pollerBackEnd");
        DefaultPollerFrontEnd.assertNotNull(this.m_pollService, "pollService");
        DefaultPollerFrontEnd.assertNotNull(this.m_pollerSettings, "pollerSettings");
    }

    @Override
    public void checkConfig() {
        this.m_state.checkIn();
    }

    public void destroy() {
        this.stop();
    }

    private OnmsLocationMonitor.MonitorStatus doCheckIn() {
        return this.m_backEnd.pollerCheckingIn(this.getMonitoringSystemId(), this.getCurrentConfigTimestamp());
    }

    private void doDelete() {
        this.setMonitoringSystemId(null);
    }

    private String doInitialize() {
        DefaultPollerFrontEnd.assertNotNull(this.m_backEnd, "pollerBackEnd");
        DefaultPollerFrontEnd.assertNotNull(this.m_pollService, "pollService");
        DefaultPollerFrontEnd.assertNotNull(this.m_pollerSettings, "pollerSettings");
        return this.getMonitoringSystemId();
    }

    private boolean doPollerStart() {
        return this.m_backEnd.pollerStarting(this.getMonitoringSystemId(), DefaultPollerFrontEnd.getDetails());
    }

    private void doPollService(Integer polledServiceId) {
        PollStatus result = this.doPoll(polledServiceId);
        if (result == null) {
            return;
        }
        this.updateServicePollState(polledServiceId, result);
        this.m_backEnd.reportResult(this.getMonitoringSystemId(), polledServiceId, result);
    }

    private void doRegister(String location) {
        String monitoringSystemId = this.m_backEnd.registerLocationMonitor(location);
        try {
            this.setMonitoringSystemId(monitoringSystemId);
        }
        catch (Throwable e) {
            LOG.warn("Unable to set monitoring system ID: " + e.getMessage(), e);
        }
    }

    private void doStop() {
        this.m_backEnd.pollerStopping(this.getMonitoringSystemId());
    }

    public static Map<String, String> getDetails() {
        HashMap<String, String> details = new HashMap<String, String>();
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            if (!e.getKey().toString().startsWith("os.") || e.getValue() == null) continue;
            details.put(e.getKey().toString(), e.getValue().toString());
        }
        InetAddress us = InetAddressUtils.getLocalHostAddress();
        details.put("org.opennms.netmgt.poller.remote.hostAddress", InetAddressUtils.str((InetAddress)us));
        details.put("org.opennms.netmgt.poller.remote.hostName", us.getHostName());
        return Collections.unmodifiableMap(details);
    }

    public String getMonitoringSystemId() {
        return this.m_pollerSettings.getMonitoringSystemId();
    }

    @Override
    public String getMonitorName() {
        return this.isRegistered() ? this.m_backEnd.getMonitorName(this.getMonitoringSystemId()) : "";
    }

    @Override
    public Collection<PolledService> getPolledServices() {
        return Arrays.asList(this.m_pollerConfiguration.getPolledServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServicePollState> getPollerPollState() {
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            return new LinkedList<ServicePollState>(this.m_pollState.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServicePollState getServicePollState(int polledServiceId) {
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            return this.m_pollState.get(polledServiceId);
        }
    }

    @Override
    public boolean isRegistered() {
        return this.m_state.isRegistered();
    }

    @Override
    public boolean isStarted() {
        return this.m_state.isStarted();
    }

    @Override
    public void pollService(Integer polledServiceId) {
        this.m_state.pollService(polledServiceId);
    }

    @Override
    public void register(String monitoringLocation) {
        this.m_state.register(monitoringLocation);
    }

    @Override
    public void removeConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.m_configChangeListeners.remove(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.remove(listener);
    }

    @Override
    public void removeServicePollStateChangedListener(ServicePollStateChangedListener listener) {
        this.m_servicePollStateChangedListeners.remove(listener);
    }

    @Override
    public void setInitialPollTime(Integer polledServiceId, Date initialPollTime) {
        ServicePollState pollState = this.getServicePollState(polledServiceId);
        if (pollState == null) {
            return;
        }
        pollState.setInitialPollTime(initialPollTime);
        this.fireServicePollStateChanged(pollState.getPolledService(), pollState.getIndex());
    }

    private void setMonitoringSystemId(String monitorId) {
        this.m_pollerSettings.setMonitoringSystemId(monitorId);
    }

    public void setPollerBackEnd(PollerBackEnd backEnd) {
        this.m_backEnd = backEnd;
    }

    public void setPollerSettings(PollerSettings settings) {
        this.m_pollerSettings = settings;
    }

    public void setTimeAdjustment(TimeAdjustment timeAdjustment) {
        this.m_timeAdjustment = timeAdjustment;
    }

    public void setPollService(PollService pollService) {
        this.m_pollService = pollService;
    }

    @Override
    public void initialize() {
        this.m_state.initialize();
    }

    @Override
    public void stop() {
        this.doStop();
        this.setState(new Stopped());
    }

    private static void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + DefaultPollerFrontEnd.class.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadConfig() {
        block6: {
            Date oldTime = this.getCurrentConfigTimestamp();
            try {
                this.m_pollService.setServiceMonitorLocators(this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR));
                this.m_pollerConfiguration = this.retrieveLatestConfiguration();
                Map<Integer, ServicePollState> map = this.m_pollState;
                synchronized (map) {
                    int i = 0;
                    this.m_pollState.clear();
                    for (PolledService service : this.getPolledServices()) {
                        this.m_pollService.initialize(service);
                        this.m_pollState.put(service.getServiceId(), new ServicePollState(service, i++));
                    }
                }
                this.fireConfigurationChange(oldTime, this.getCurrentConfigTimestamp());
            }
            catch (Throwable e) {
                LOG.warn("Unable to get updated poller configuration.", e);
                if (this.m_pollerConfiguration != null) break block6;
                this.m_pollerConfiguration = new EmptyPollerConfiguration();
            }
        }
    }

    private PollerConfiguration retrieveLatestConfiguration() {
        PollerConfiguration config = this.m_backEnd.getPollerConfiguration(this.getMonitoringSystemId());
        this.m_timeAdjustment.setMasterTime(config.getServerTime());
        return config;
    }

    private PollStatus doPoll(Integer polledServiceId) {
        PolledService polledService = this.getPolledService(polledServiceId);
        if (polledService == null) {
            return null;
        }
        return this.m_pollService.poll(polledService);
    }

    private void fireConfigurationChange(Date oldTime, Date newTime) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, "configuration", oldTime, newTime);
        for (ConfigurationChangedListener listener : this.m_configChangeListeners) {
            listener.configurationChanged(e);
        }
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (DefaultPollerFrontEnd.nullSafeEquals(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.m_propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private static boolean nullSafeEquals(Object oldValue, Object newValue) {
        return oldValue == newValue ? true : ObjectUtils.nullSafeEquals((Object)oldValue, (Object)newValue);
    }

    private void fireServicePollStateChanged(PolledService polledService, int index) {
        ServicePollStateChangedEvent event = new ServicePollStateChangedEvent(polledService, index);
        for (ServicePollStateChangedListener listener : this.m_servicePollStateChangedListeners) {
            listener.pollStateChange(event);
        }
    }

    private Date getCurrentConfigTimestamp() {
        return this.m_pollerConfiguration == null ? null : this.m_pollerConfiguration.getConfigurationTimestamp();
    }

    private PolledService getPolledService(Integer polledServiceId) {
        ServicePollState servicePollState = this.getServicePollState(polledServiceId);
        return servicePollState == null ? null : servicePollState.getPolledService();
    }

    private void setState(PollerFrontEndState newState) {
        boolean started = this.isStarted();
        boolean registered = this.isRegistered();
        boolean paused = this.isPaused();
        boolean disconnected = this.isDisconnected();
        boolean exitNecessary = this.isExitNecessary();
        this.m_state = newState;
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.exitNecessary.toString(), exitNecessary, this.isExitNecessary());
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.started.toString(), started, this.isStarted());
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.registered.toString(), registered, this.isRegistered());
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.paused.toString(), paused, this.isPaused());
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.disconnected.toString(), disconnected, this.isDisconnected());
    }

    @Override
    public boolean isDisconnected() {
        return this.m_state.isDisconnected();
    }

    @Override
    public boolean isPaused() {
        return this.m_state.isPaused();
    }

    @Override
    public boolean isExitNecessary() {
        return this.m_state.isExitNecessary();
    }

    private void updateServicePollState(Integer polledServiceId, PollStatus result) {
        ServicePollState pollState = this.getServicePollState(polledServiceId);
        if (pollState == null) {
            return;
        }
        pollState.setLastPoll(result);
        this.fireServicePollStateChanged(pollState.getPolledService(), pollState.getIndex());
    }

    private class Running
    extends RunningState {
        private Running() {
        }

        @Override
        public void pollService(Integer polledServiceId) {
            try {
                DefaultPollerFrontEnd.this.doPollService(polledServiceId);
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception occurred while polling service ID {}.", (Object)polledServiceId, (Object)e);
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred(e));
            }
        }

        @Override
        protected void onConfigChanged() {
            DefaultPollerFrontEnd.this.doLoadConfig();
        }

        @Override
        protected void onDisconnected() {
            DefaultPollerFrontEnd.this.doDisconnected();
            DefaultPollerFrontEnd.this.setState(new Disconnected());
        }

        @Override
        protected void onPaused() {
            DefaultPollerFrontEnd.this.doPause();
            DefaultPollerFrontEnd.this.setState(new Paused());
        }
    }

    private class RunningState
    extends PollerFrontEndState {
        private RunningState() {
        }

        @Override
        public void pollService(Integer serviceId) {
        }

        @Override
        public void checkIn() {
            File killSwitch;
            try {
                OnmsLocationMonitor.MonitorStatus status = DefaultPollerFrontEnd.this.doCheckIn();
                switch (status) {
                    case CONFIG_CHANGED: {
                        this.onConfigChanged();
                        break;
                    }
                    case DELETED: {
                        this.onDeleted();
                        break;
                    }
                    case DISCONNECTED: {
                        this.onDisconnected();
                        break;
                    }
                    case PAUSED: {
                        this.onPaused();
                        break;
                    }
                    case STARTED: {
                        this.onStarted();
                        break;
                    }
                    case STOPPED: {
                        LOG.info("State set to STOPPED; stopping");
                        DefaultPollerFrontEnd.this.stop();
                        break;
                    }
                    default: {
                        LOG.debug("Unhandled status on checkIn(): {}", (Object)status);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception occurred while checking in.", e);
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred(e));
            }
            String killSwitchFileName = System.getProperty("opennms.poller.killSwitch.resource");
            if (!"".equals(killSwitchFileName) && killSwitchFileName != null && !(killSwitch = new File(System.getProperty("opennms.poller.killSwitch.resource"))).exists()) {
                LOG.info("Kill-switch file {} does not exist; stopping.", (Object)killSwitch.getPath());
                DefaultPollerFrontEnd.this.stop();
            }
        }

        @Override
        public boolean isStarted() {
            return true;
        }

        protected void onConfigChanged() {
        }

        protected void onDeleted() {
            DefaultPollerFrontEnd.this.doDelete();
            DefaultPollerFrontEnd.this.setState(new Registering());
        }

        protected void onDisconnected() {
        }

        protected void onPaused() {
        }

        protected void onStarted() {
        }
    }

    private class Registering
    extends PollerFrontEndState {
        private Registering() {
        }

        @Override
        public boolean isRegistered() {
            return false;
        }

        @Override
        public void register(String location) {
            try {
                DefaultPollerFrontEnd.this.doRegister(location);
                DefaultPollerFrontEnd.this.doPollerStart();
                DefaultPollerFrontEnd.this.setState(new Running());
                DefaultPollerFrontEnd.this.doLoadConfig();
            }
            catch (Throwable e) {
                LOG.warn("Unable to register.", e);
                DefaultPollerFrontEnd.this.setState(new Disconnected());
            }
        }
    }

    private class Paused
    extends RunningState {
        private Paused() {
        }

        @Override
        protected void onConfigChanged() {
            DefaultPollerFrontEnd.this.doLoadConfig();
        }

        @Override
        public boolean isPaused() {
            return true;
        }

        @Override
        protected void onDisconnected() {
            DefaultPollerFrontEnd.this.doDisconnected();
            DefaultPollerFrontEnd.this.setState(new Disconnected());
        }

        @Override
        protected void onStarted() {
            DefaultPollerFrontEnd.this.doResume();
            DefaultPollerFrontEnd.this.setState(new Running());
        }
    }

    private class Initial
    extends PollerFrontEndState {
        private Initial() {
        }

        @Override
        public void initialize() {
            try {
                String monitorId = DefaultPollerFrontEnd.this.doInitialize();
                if (monitorId == null) {
                    DefaultPollerFrontEnd.this.setState(new Registering());
                } else if (DefaultPollerFrontEnd.this.doPollerStart()) {
                    DefaultPollerFrontEnd.this.setState(new Running());
                    DefaultPollerFrontEnd.this.doLoadConfig();
                } else {
                    DefaultPollerFrontEnd.this.doDelete();
                    DefaultPollerFrontEnd.this.setState(new Registering());
                }
            }
            catch (Throwable e) {
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred(e));
                throw e;
            }
        }

        @Override
        public boolean isRegistered() {
            return false;
        }
    }

    private static class Stopped
    extends PollerFrontEndState {
        private Stopped() {
        }

        @Override
        public boolean isExitNecessary() {
            return true;
        }
    }

    private class Disconnected
    extends RunningState {
        private Disconnected() {
        }

        @Override
        public boolean isDisconnected() {
            return true;
        }

        @Override
        protected void onConfigChanged() {
            DefaultPollerFrontEnd.this.setState(new Running());
            DefaultPollerFrontEnd.this.doLoadConfig();
        }

        @Override
        protected void onPaused() {
            DefaultPollerFrontEnd.this.doPause();
            DefaultPollerFrontEnd.this.setState(new Paused());
        }

        @Override
        protected void onStarted() {
            DefaultPollerFrontEnd.this.setState(new Running());
            DefaultPollerFrontEnd.this.doLoadConfig();
        }
    }
}

