/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.BridgeMacLinkHash;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BroadcastDomain;

public class SharedSegment {
    BridgePort m_designatedBridge;
    List<BridgeMacLink> m_macsOnSegment = new ArrayList<BridgeMacLink>();
    Set<BridgePort> m_portsOnSegment = new HashSet<BridgePort>();
    BroadcastDomain m_domain;

    private BridgePort getFromBridgeMacLink(BridgeMacLink link) {
        BridgePort bp = new BridgePort();
        bp.setNode(link.getNode());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setBridgePortIfName(link.getBridgePortIfName());
        bp.setVlan(link.getVlan());
        bp.setCreateTime(link.getBridgeMacLinkCreateTime());
        bp.setPollTime(link.getBridgeMacLinkLastPollTime());
        return bp;
    }

    private BridgePort getFromBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNode(link.getNode());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setBridgePortIfName(link.getBridgePortIfName());
        bp.setVlan(link.getVlan());
        bp.setCreateTime(link.getBridgeBridgeLinkCreateTime());
        bp.setPollTime(link.getBridgeBridgeLinkLastPollTime());
        return bp;
    }

    private BridgePort getFromDesignatedBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNode(link.getDesignatedNode());
        bp.setBridgePort(link.getDesignatedPort());
        bp.setBridgePortIfIndex(link.getDesignatedPortIfIndex());
        bp.setBridgePortIfName(link.getDesignatedPortIfName());
        bp.setVlan(link.getDesignatedVlan());
        bp.setCreateTime(link.getBridgeBridgeLinkCreateTime());
        bp.setPollTime(link.getBridgeBridgeLinkLastPollTime());
        return bp;
    }

    private BridgeBridgeLink getBridgeBridgeLink(BridgePort bp) {
        BridgeBridgeLink link = new BridgeBridgeLink();
        link.setNode(bp.getNode());
        link.setBridgePort(bp.getBridgePort());
        link.setBridgePortIfIndex(bp.getBridgePortIfIndex());
        link.setBridgePortIfName(bp.getBridgePortIfName());
        link.setVlan(bp.getVlan());
        link.setDesignatedNode(this.m_designatedBridge.getNode());
        link.setDesignatedPort(this.m_designatedBridge.getBridgePort());
        link.setDesignatedPortIfIndex(this.m_designatedBridge.getBridgePortIfIndex());
        link.setDesignatedPortIfName(this.m_designatedBridge.getBridgePortIfName());
        link.setDesignatedVlan(this.m_designatedBridge.getVlan());
        link.setBridgeBridgeLinkCreateTime(this.m_designatedBridge.getCreateTime());
        link.setBridgeBridgeLinkLastPollTime(this.m_designatedBridge.getPollTime());
        return link;
    }

    public SharedSegment() {
    }

    public SharedSegment(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public BroadcastDomain getBroadcastDomain() {
        return this.m_domain;
    }

    public void setBroadcastDomain(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public SharedSegment(BroadcastDomain domain, BridgeMacLink link) {
        this.m_domain = domain;
        this.m_designatedBridge = this.getFromBridgeMacLink(link);
        this.m_macsOnSegment.add(link);
        this.m_portsOnSegment.add(this.m_designatedBridge);
    }

    public SharedSegment(BroadcastDomain domain, BridgeBridgeLink link) {
        this.m_domain = domain;
        this.m_portsOnSegment.add(this.getFromDesignatedBridgeBridgeLink(link));
        this.m_portsOnSegment.add(this.getFromBridgeBridgeLink(link));
    }

    public void setDesignatedBridge(Integer designatedBridge) {
        if (designatedBridge == null) {
            return;
        }
        if (this.m_designatedBridge != null && designatedBridge != null && this.m_designatedBridge.getNode().getId().intValue() == designatedBridge.intValue()) {
            return;
        }
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.getNode().getId().intValue() != designatedBridge.intValue()) continue;
            this.m_designatedBridge = port;
            break;
        }
    }

    public Integer getDesignatedBridge() {
        return this.m_designatedBridge.getNode().getId();
    }

    public Integer getDesignatedPort() {
        return this.m_designatedBridge.getBridgePort();
    }

    public boolean isEmpty() {
        return this.m_macsOnSegment.isEmpty() && this.m_portsOnSegment.isEmpty();
    }

    public Set<BridgePort> getBridgePortsOnSegment() {
        return this.m_portsOnSegment;
    }

    public List<BridgeBridgeLink> getBridgeBridgeLinks() {
        ArrayList<BridgeBridgeLink> links = new ArrayList<BridgeBridgeLink>();
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.equals(this.m_designatedBridge)) continue;
            links.add(this.getBridgeBridgeLink(port));
        }
        return links;
    }

    public List<BridgeMacLink> getBridgeMacLinks() {
        return this.m_macsOnSegment;
    }

    public boolean noMacsOnSegment() {
        return this.m_macsOnSegment.isEmpty();
    }

    public void setBridgeMacLinks(List<BridgeMacLink> links) {
        this.m_macsOnSegment = links;
        for (BridgeMacLink link : links) {
            this.m_portsOnSegment.add(this.getFromBridgeMacLink(link));
        }
    }

    public void add(BridgeMacLink link) {
        this.m_macsOnSegment.add(link);
        this.m_portsOnSegment.add(this.getFromBridgeMacLink(link));
    }

    public void add(BridgeBridgeLink dlink) {
        this.m_portsOnSegment.add(this.getFromDesignatedBridgeBridgeLink(dlink));
        this.m_portsOnSegment.add(this.getFromBridgeBridgeLink(dlink));
    }

    public void mergeBridge(SharedSegment shared, Integer bridgeId) {
        BridgeMacLink nlink;
        ArrayList<BridgeMacLink> toadd = new ArrayList<BridgeMacLink>();
        for (BridgeMacLink link : this.m_macsOnSegment) {
            if (link.getNode().getId().intValue() != this.m_designatedBridge.getNode().getId().intValue()) continue;
            for (BridgePort mport : shared.getBridgePortsOnSegment()) {
                if (mport.getNode().getId().intValue() == bridgeId.intValue()) continue;
                nlink = new BridgeMacLink();
                nlink.setNode(mport.getNode());
                nlink.setBridgePort(mport.getBridgePort());
                nlink.setBridgePortIfIndex(mport.getBridgePortIfIndex());
                nlink.setBridgePortIfName(mport.getBridgePortIfName());
                nlink.setVlan(mport.getVlan());
                nlink.setMacAddress(link.getMacAddress());
                nlink.setBridgeMacLinkCreateTime(link.getBridgeMacLinkCreateTime());
                nlink.setBridgeMacLinkLastPollTime(link.getBridgeMacLinkLastPollTime());
                nlink.setBridgeDot1qTpFdbStatus(link.getBridgeDot1qTpFdbStatus());
                toadd.add(nlink);
            }
        }
        this.m_macsOnSegment.addAll(toadd);
        for (BridgeMacLink mlink : shared.getBridgeMacLinks()) {
            if (mlink.getNode().getId().intValue() == bridgeId.intValue()) {
                for (BridgePort port : this.m_portsOnSegment) {
                    nlink = new BridgeMacLink();
                    nlink.setNode(port.getNode());
                    nlink.setBridgePort(port.getBridgePort());
                    nlink.setBridgePortIfIndex(port.getBridgePortIfIndex());
                    nlink.setBridgePortIfName(port.getBridgePortIfName());
                    nlink.setVlan(port.getVlan());
                    nlink.setMacAddress(mlink.getMacAddress());
                    nlink.setBridgeMacLinkCreateTime(mlink.getBridgeMacLinkCreateTime());
                    nlink.setBridgeMacLinkLastPollTime(mlink.getBridgeMacLinkLastPollTime());
                    nlink.setBridgeDot1qTpFdbStatus(mlink.getBridgeDot1qTpFdbStatus());
                    this.m_macsOnSegment.add(nlink);
                }
                continue;
            }
            this.m_macsOnSegment.add(mlink);
        }
        for (BridgePort port : shared.getBridgePortsOnSegment()) {
            if (port.getNode().getId().intValue() == bridgeId.intValue()) continue;
            this.m_portsOnSegment.add(port);
        }
    }

    public void assign(List<BridgeMacLink> links, BridgeBridgeLink dlink) {
        this.add(dlink);
        HashMap<BridgeMacLinkHash, BridgeMacLink> sharedsegmentmaclinks = new HashMap<BridgeMacLinkHash, BridgeMacLink>();
        for (BridgeMacLink link : links) {
            sharedsegmentmaclinks.put(new BridgeMacLinkHash(link), link);
        }
        for (BridgeMacLink link : this.m_macsOnSegment) {
            sharedsegmentmaclinks.put(new BridgeMacLinkHash(link), link);
            this.m_portsOnSegment.add(this.getFromBridgeMacLink(link));
        }
        this.m_macsOnSegment = new ArrayList(sharedsegmentmaclinks.values());
    }

    public void removeBridge(int bridgeId) {
        if (this.m_portsOnSegment.isEmpty()) {
            return;
        }
        HashSet<BridgePort> updateportsonsegment = new HashSet<BridgePort>();
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.getNode().getId() == bridgeId) continue;
            updateportsonsegment.add(port);
        }
        this.m_portsOnSegment = updateportsonsegment;
        ArrayList<BridgeMacLink> updatemacsonsegment = new ArrayList<BridgeMacLink>();
        for (BridgeMacLink link : this.m_macsOnSegment) {
            if (link.getNode().getId() == bridgeId) continue;
            updatemacsonsegment.add(link);
        }
        this.m_macsOnSegment = updatemacsonsegment;
    }

    public void removeMacs(Map<Integer, List<BridgeMacLink>> throughset) {
        HashSet<String> mactoberemoved = new HashSet<String>();
        for (Integer port : throughset.keySet()) {
            for (BridgeMacLink link : throughset.get(port)) {
                mactoberemoved.add(link.getMacAddress());
            }
        }
        ArrayList<BridgeMacLink> curlist = new ArrayList<BridgeMacLink>();
        for (BridgeMacLink link : this.m_macsOnSegment) {
            if (mactoberemoved.contains(link.getMacAddress())) continue;
            curlist.add(link);
        }
        this.m_macsOnSegment = curlist;
    }

    public Integer getFirstNoDesignatedBridge() {
        for (Integer bridgeId : this.getBridgeIdsOnSegment()) {
            if (this.m_designatedBridge != null && bridgeId == this.m_designatedBridge.getNode().getId()) continue;
            return bridgeId;
        }
        return null;
    }

    public Set<String> getMacsOnSegment() {
        HashSet<String> macs = new HashSet<String>();
        for (BridgeMacLink link : this.m_macsOnSegment) {
            macs.add(link.getMacAddress());
        }
        return macs;
    }

    public Set<Integer> getBridgeIdsOnSegment() {
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (BridgePort link : this.m_portsOnSegment) {
            nodes.add(link.getNode().getId());
        }
        return nodes;
    }

    public boolean containsMac(String mac) {
        if (mac == null) {
            return false;
        }
        for (BridgeMacLink link : this.m_macsOnSegment) {
            if (!mac.equals(link.getMacAddress())) continue;
            return true;
        }
        return false;
    }

    public boolean containsPort(Integer nodeid, Integer bridgeport) {
        for (BridgePort link : this.m_portsOnSegment) {
            if (link.getNode().getId().intValue() != nodeid.intValue() || link.getBridgePort().intValue() != bridgeport.intValue()) continue;
            return true;
        }
        return false;
    }

    public Integer getPortForBridge(Integer nodeid) {
        if (nodeid == null) {
            return null;
        }
        if (this.m_macsOnSegment.isEmpty()) {
            for (BridgePort link : this.m_portsOnSegment) {
                if (link.getNode().getId().intValue() != nodeid.intValue()) continue;
                return link.getBridgePort();
            }
            return null;
        }
        return null;
    }
}

