/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.opennms.netmgt.dao.api.EventdServiceManager;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.processor.EventWriter;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public abstract class AbstractJdbcPersister
implements InitializingBean,
EventWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcPersister.class);
    private EventdServiceManager m_eventdServiceManager;
    private EventUtil m_eventUtil;
    private DataSource m_dataSource;
    private String m_getNextIdString;

    protected static void set(PreparedStatement stmt, int ndx, String value) throws SQLException {
        if (value == null || value.length() == 0) {
            stmt.setNull(ndx, 12);
        } else {
            stmt.setString(ndx, value);
        }
    }

    protected static void set(PreparedStatement stmt, int ndx, int value) throws SQLException {
        if (value < 0) {
            stmt.setNull(ndx, 4);
        } else {
            stmt.setInt(ndx, value);
        }
    }

    protected static void set(PreparedStatement stmt, int ndx, Timestamp value) throws SQLException {
        if (value == null) {
            stmt.setNull(ndx, 93);
        } else {
            stmt.setTimestamp(ndx, value);
        }
    }

    protected static void set(PreparedStatement stmt, int ndx, char value) throws SQLException {
        stmt.setString(ndx, String.valueOf(value));
    }

    protected int getServiceID(String name) throws SQLException {
        return this.m_eventdServiceManager.getServiceId(name);
    }

    protected static Timestamp getEventTime(Event event) {
        return new Timestamp(event.getTime().getTime());
    }

    protected int getNextId() throws SQLException {
        return (Integer)new JdbcTemplate(this.getDataSource()).queryForObject(this.getGetNextIdString(), Integer.class);
    }

    public void afterPropertiesSet() throws SQLException {
        Assert.state((this.m_eventdServiceManager != null ? 1 : 0) != 0, (String)"property eventdServiceManager must be set");
        Assert.state((this.m_eventUtil != null ? 1 : 0) != 0, (String)"property eventUtil must be set");
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource must be set");
        Assert.state((this.m_getNextIdString != null ? 1 : 0) != 0, (String)"property getNextIdString must be set");
    }

    public EventdServiceManager getEventdServiceManager() {
        return this.m_eventdServiceManager;
    }

    public void setEventdServiceManager(EventdServiceManager eventdServiceManager) {
        this.m_eventdServiceManager = eventdServiceManager;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public EventUtil getEventUtil() {
        return this.m_eventUtil;
    }

    public void setEventUtil(EventUtil eventUtil) {
        this.m_eventUtil = eventUtil;
    }

    public String getGetNextIdString() {
        return this.m_getNextIdString;
    }

    public void setGetNextIdString(String getNextIdString) {
        this.m_getNextIdString = getNextIdString;
    }

    protected static boolean checkEventSanityAndDoWeProcess(Event event, String logPrefix) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)event.getLogmsg(), (String)"event does not have a logmsg");
        if ("donotpersist".equals(event.getLogmsg().getDest()) || "suppress".equals(event.getLogmsg().getDest())) {
            LOG.debug("{}: uei '{}' marked as '{}'; not processing event.", new Object[]{logPrefix, event.getUei(), event.getLogmsg().getDest()});
            return false;
        }
        return true;
    }
}

