/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import org.opennms.netmgt.collectd.AliasedGroup;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.utils.NodeLabelJDBCImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasedResource
extends SnmpCollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(AliasedResource.class);
    private final IfInfo m_ifInfo;
    private final String m_ifAliasComment;
    private final String m_domain;
    private final String m_ifAlias;

    public AliasedResource(ResourceType resourceType, String domain, IfInfo ifInfo, String ifAliasComment, String ifAlias) {
        super(resourceType);
        this.m_domain = domain;
        this.m_ifInfo = ifInfo;
        this.m_ifAliasComment = ifAliasComment;
        this.m_ifAlias = ifAlias;
    }

    public IfInfo getIfInfo() {
        return this.m_ifInfo;
    }

    String getAliasDir() {
        return this.getIfInfo().getAliasDir(this.m_ifAlias, this.m_ifAliasComment);
    }

    public String getDomain() {
        if ("nodeid".equalsIgnoreCase(this.m_domain)) {
            return Integer.toString(this.getIfInfo().getNodeId());
        }
        if ("nodelabel".equalsIgnoreCase(this.m_domain)) {
            try {
                return new NodeLabelJDBCImpl().retrieveLabel(this.getIfInfo().getNodeId()).getLabel();
            }
            catch (Throwable e) {
                return "nodeid-" + Integer.toString(this.getIfInfo().getNodeId());
            }
        }
        return this.m_domain;
    }

    public Path getPath() {
        return Paths.get(this.getDomain(), this.getAliasDir());
    }

    public String toString() {
        return this.getDomain() + '/' + this.getAliasDir() + " [" + this.m_ifInfo + ']';
    }

    @Override
    public boolean rescanNeeded() {
        boolean outOfDate = this.getIfInfo().currentAliasIsOutOfDate(this.m_ifAlias);
        if (outOfDate) {
            this.getIfInfo().setIfAlias(this.m_ifAlias);
        }
        return outOfDate;
    }

    public boolean isScheduledForCollection() {
        return this.getIfInfo().isScheduledForCollection();
    }

    @Override
    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdPrsist = serviceParameters.aliasesEnabled() && this.getAliasDir() != null && !this.getAliasDir().equals("") && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getAliasDir()));
        LOG.debug("shouldPersist = {}", (Object)shdPrsist);
        return shdPrsist;
    }

    @Override
    public int getSnmpIfType() {
        return this.getIfInfo().getSnmpIfType();
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource((CollectionResource)this);
        Iterator<AttributeGroup> it = this.getGroups().iterator();
        while (it.hasNext()) {
            AliasedGroup aliased = new AliasedGroup(this, it.next());
            aliased.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
    }

    @Override
    public Collection<AttributeGroup> getGroups() {
        return this.getIfInfo().getGroups();
    }

    public String getResourceTypeName() {
        return "if";
    }

    public String getInstance() {
        return null;
    }

    public String getParent() {
        return null;
    }

    public String getInterfaceLabel() {
        return this.getDomain() + '/' + this.getAliasDir();
    }

    @Override
    public TimeKeeper getTimeKeeper() {
        return null;
    }
}

